"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogLevel = exports.Logger = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const chalk = require("chalk");
const common_1 = require("./common");
const component_1 = require("./component");
const logging_1 = require("./logging");
const util_1 = require("./util");
/**
 * (experimental) Project-level logging utilities.
 *
 * @experimental
 */
class Logger extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b, _c;
        super(project);
        // if we are running inside a test, default to no logs
        const defaultLevel = common_1.IS_TEST_RUN ? LogLevel.OFF : LogLevel.INFO;
        this.level = (_b = options.level) !== null && _b !== void 0 ? _b : defaultLevel;
        this.usePrefix = (_c = options.usePrefix) !== null && _c !== void 0 ? _c : false;
    }
    /**
     * (experimental) Log a message to stderr with a given logging level.
     *
     * The message will be
     * printed as long as `logger.level` is set to the message's severity or higher.
     *
     * @param level Logging verbosity.
     * @param text strings or objects to print.
     * @experimental
     */
    log(level, ...text) {
        if (level === LogLevel.OFF) {
            throw new Error('Cannot log a message with level LogLevel.OFF');
        }
        let maxLevel = this.level;
        // logging level can be overridden through the --debug CLI option
        if (util_1.isTruthy(process.env.DEBUG) && maxLevel < LogLevel.DEBUG) {
            maxLevel = LogLevel.DEBUG;
        }
        if (level <= maxLevel) {
            const color = this.colorForLogLevel(level);
            const prefix = this.usePrefix ? `[${this.project.name}] ` : '';
            console.error(`${logging_1.ICON} ${prefix}${color(...text)}`);
        }
    }
    /**
     * (experimental) Log a message to stderr with VERBOSE severity.
     *
     * @param text strings or objects to print.
     * @experimental
     */
    verbose(...text) {
        this.log(LogLevel.VERBOSE, ...text);
    }
    /**
     * (experimental) Log a message to stderr with DEBUG severity.
     *
     * @param text strings or objects to print.
     * @experimental
     */
    debug(...text) {
        this.log(LogLevel.DEBUG, ...text);
    }
    /**
     * (experimental) Log a message to stderr with INFO severity.
     *
     * @param text strings or objects to print.
     * @experimental
     */
    info(...text) {
        this.log(LogLevel.INFO, ...text);
    }
    /**
     * (experimental) Log a message to stderr with WARN severity.
     *
     * @param text strings or objects to print.
     * @experimental
     */
    warn(...text) {
        this.log(LogLevel.WARN, ...text);
    }
    /**
     * (experimental) Log a message to stderr with ERROR severity.
     *
     * @param text strings or objects to print.
     * @experimental
     */
    error(...text) {
        this.log(LogLevel.ERROR, ...text);
    }
    colorForLogLevel(level) {
        switch (level) {
            case LogLevel.ERROR: return chalk.red;
            case LogLevel.WARN: return chalk.yellow;
            case LogLevel.INFO: return chalk.cyan;
            case LogLevel.DEBUG: return chalk.gray;
            case LogLevel.VERBOSE: return chalk.white;
            default:
                return chalk.white;
        }
    }
}
exports.Logger = Logger;
_a = JSII_RTTI_SYMBOL_1;
Logger[_a] = { fqn: "projen.Logger", version: "0.46.3" };
/**
 * (experimental) Logging verbosity.
 *
 * @experimental
 */
var LogLevel;
(function (LogLevel) {
    LogLevel["OFF"] = "00.off";
    LogLevel["ERROR"] = "10.error";
    LogLevel["WARN"] = "20.warn";
    LogLevel["INFO"] = "30.info";
    LogLevel["DEBUG"] = "40.debug";
    LogLevel["VERBOSE"] = "50.verbose";
})(LogLevel = exports.LogLevel || (exports.LogLevel = {}));
//# sourceMappingURL=data:application/json;base64,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