"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpgradeDependenciesSchedule = exports.UpgradeDependencies = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const github_1 = require("../github");
const constants_1 = require("../github/constants");
function context(value) {
    return `\${{ ${value} }}`;
}
function setOutput(name, value) {
    return `echo "::set-output name=${name}::${value}"`;
}
const RUNNER_TEMP = context('runner.temp');
const DEFAULT_TOKEN = context('secrets.GITHUB_TOKEN');
const REPO = context('github.repository');
const RUN_ID = context('github.run_id');
const RUN_URL = `https://github.com/${REPO}/actions/runs/${RUN_ID}`;
/**
 * (experimental) Upgrade node project dependencies.
 *
 * @experimental
 */
class UpgradeDependencies extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _c, _d, _e, _f, _g;
        super(project);
        /**
         * (experimental) The workflows that execute the upgrades.
         *
         * One workflow per branch.
         *
         * @experimental
         */
        this.workflows = [];
        this._project = project;
        this.options = options;
        this.pullRequestTitle = (_c = options.pullRequestTitle) !== null && _c !== void 0 ? _c : 'upgrade dependencies';
        this.ignoresProjen = (_d = this.options.ignoreProjen) !== null && _d !== void 0 ? _d : true;
        this.gitIdentity = (_f = (_e = options.workflowOptions) === null || _e === void 0 ? void 0 : _e.gitIdentity) !== null && _f !== void 0 ? _f : constants_1.DEFAULT_GITHUB_ACTIONS_USER;
        this.postBuildSteps = [];
        this.containerOptions = (_g = options.workflowOptions) === null || _g === void 0 ? void 0 : _g.container;
        project.addDevDeps('npm-check-updates@^12');
    }
    /**
     * (experimental) Add steps to execute a successful build.
     *
     * @param steps worklfow steps.
     * @experimental
     */
    addPostBuildSteps(...steps) {
        this.postBuildSteps.push(...steps);
    }
    // create the upgrade task and a corresponding github workflow
    // for each requested branch.
    /**
     * (experimental) Called before synthesis.
     *
     * @experimental
     */
    preSynthesize() {
        var _c, _d, _e, _f, _g;
        const task = this.createTask();
        if (this._project.github && ((_c = this.options.workflow) !== null && _c !== void 0 ? _c : true)) {
            // represents the default repository branch.
            // just like not specifying anything.
            const defaultBranch = undefined;
            const branches = (_e = (_d = this.options.workflowOptions) === null || _d === void 0 ? void 0 : _d.branches) !== null && _e !== void 0 ? _e : ((_g = (_f = this._project.release) === null || _f === void 0 ? void 0 : _f.branches) !== null && _g !== void 0 ? _g : [defaultBranch]);
            for (const branch of branches) {
                this.workflows.push(this.createWorkflow(task, this._project.github, branch));
            }
        }
    }
    createTask() {
        var _c, _d;
        const taskName = (_c = this.options.taskName) !== null && _c !== void 0 ? _c : 'upgrade';
        const task = this._project.addTask(taskName, {
            // this task should not run in CI mode because its designed to
            // update package.json and lock files.
            env: { CI: '0' },
            description: this.pullRequestTitle,
        });
        const exclude = (_d = this.options.exclude) !== null && _d !== void 0 ? _d : [];
        if (this.ignoresProjen) {
            exclude.push('projen');
        }
        for (const dep of ['dev', 'optional', 'peer', 'prod', 'bundle']) {
            const ncuCommand = ['npm-check-updates', '--dep', dep, '--upgrade', '--target=minor'];
            if (exclude.length > 0) {
                ncuCommand.push(`--reject='${exclude.join(',')}'`);
            }
            if (this.options.include) {
                ncuCommand.push(`--filter='${this.options.include.join(',')}'`);
            }
            task.exec(ncuCommand.join(' '));
        }
        // run "yarn/npm install" to update the lockfile and install any deps (such as projen)
        task.exec(this._project.package.installAndUpdateLockfileCommand);
        // run upgrade command to upgrade transitive deps as well
        task.exec(this._project.package.renderUpgradePackagesCommand(exclude, this.options.include));
        // run "projen" to give projen a chance to update dependencies (it will also run "yarn install")
        task.exec(this._project.projenCommand);
        return task;
    }
    createWorkflow(task, github, branch) {
        var _c, _d;
        const schedule = (_d = (_c = this.options.workflowOptions) === null || _c === void 0 ? void 0 : _c.schedule) !== null && _d !== void 0 ? _d : UpgradeDependenciesSchedule.DAILY;
        const workflowName = `${task.name}${branch ? `-${branch.replace(/\//g, '-')}` : ''}`;
        const workflow = github.addWorkflow(workflowName);
        const triggers = {
            workflowDispatch: {},
            schedule: schedule.cron ? schedule.cron.map(e => ({ cron: e })) : undefined,
        };
        workflow.on(triggers);
        const upgrade = this.createUpgrade(task, branch);
        const pr = this.createPr(workflow, upgrade);
        const jobs = {};
        jobs[upgrade.jobId] = upgrade.job;
        jobs[pr.jobId] = pr.job;
        workflow.addJobs(jobs);
        return workflow;
    }
    createUpgrade(task, branch) {
        var _c, _d, _e, _f;
        const build = (_d = (_c = this.options.workflowOptions) === null || _c === void 0 ? void 0 : _c.rebuild) !== null && _d !== void 0 ? _d : true;
        const runsOn = (_f = (_e = this.options.workflowOptions) === null || _e === void 0 ? void 0 : _e.runsOn) !== null && _f !== void 0 ? _f : ['ubuntu-latest'];
        const patchFile = '.upgrade.tmp.patch';
        const buildStepId = 'build';
        const conclusion = 'conclusion';
        // thats all we should need at this stage since all we do is clone.
        // note that this also prevents new code that is introduced in the upgrade
        // to have write access to anything, in case its somehow executed. (for example during build)
        const permissions = {
            contents: github_1.workflows.JobPermission.READ,
        };
        const outputs = {};
        const steps = [
            {
                name: 'Checkout',
                uses: 'actions/checkout@v2',
                with: branch ? { ref: branch } : undefined,
            },
            constants_1.setGitIdentityStep(this.gitIdentity),
            ...this._project.installWorkflowSteps,
            {
                name: 'Upgrade dependencies',
                run: this._project.runTaskCommand(task),
            },
        ];
        if (build) {
            steps.push({
                name: 'Build',
                id: buildStepId,
                run: `${this._project.runTaskCommand(this._project.buildTask)} && ${setOutput(conclusion, 'success')} || ${setOutput(conclusion, 'failure')}`,
            });
            outputs[conclusion] = {
                stepId: buildStepId,
                outputName: conclusion,
            };
        }
        steps.push(...this.postBuildSteps);
        steps.push({
            name: 'Create Patch',
            run: [
                'git add .',
                `git diff --patch --staged > ${patchFile}`,
            ].join('\n'),
        }, {
            name: 'Upload patch',
            uses: 'actions/upload-artifact@v2',
            with: { name: patchFile, path: patchFile },
        });
        return {
            job: {
                name: 'Upgrade',
                container: this.containerOptions,
                permissions: permissions,
                runsOn: runsOn !== null && runsOn !== void 0 ? runsOn : ['ubuntu-latest'],
                outputs: outputs,
                steps: steps,
            },
            jobId: 'upgrade',
            patchFile: patchFile,
            build: build,
            buildConclusionOutput: conclusion,
            ref: branch,
        };
    }
    createPr(workflow, upgrade) {
        var _c, _d, _e, _f, _g, _h;
        const customToken = ((_c = this.options.workflowOptions) === null || _c === void 0 ? void 0 : _c.secret) ? context(`secrets.${this.options.workflowOptions.secret}`) : undefined;
        const runsOn = (_e = (_d = this.options.workflowOptions) === null || _d === void 0 ? void 0 : _d.runsOn) !== null && _e !== void 0 ? _e : ['ubuntu-latest'];
        const workflowName = workflow.name;
        const branchName = `github-actions/${workflowName}`;
        const prStepId = 'create-pr';
        const title = `chore(deps): ${this.pullRequestTitle}`;
        const description = [
            'Upgrades project dependencies. See details in [workflow run].',
            '',
            `[Workflow Run]: ${RUN_URL}`,
            '',
            '------',
            '',
            `*Automatically created by projen via the "${workflow.name}" workflow*`,
        ].join('\n');
        const comitter = `${this.gitIdentity.name} <${this.gitIdentity.email}>`;
        const steps = [
            {
                name: 'Checkout',
                uses: 'actions/checkout@v2',
                with: upgrade.ref ? { ref: upgrade.ref } : undefined,
            },
            constants_1.setGitIdentityStep(this.gitIdentity),
            {
                name: 'Download patch',
                uses: 'actions/download-artifact@v2',
                with: { name: upgrade.patchFile, path: RUNNER_TEMP },
            },
            {
                name: 'Apply patch',
                run: `[ -s ${RUNNER_TEMP}/${upgrade.patchFile} ] && git apply ${RUNNER_TEMP}/${upgrade.patchFile} || echo "Empty patch. Skipping."`,
            },
            {
                name: 'Create Pull Request',
                id: prStepId,
                uses: 'peter-evans/create-pull-request@v3',
                with: {
                    // the pr can modify workflow files, so we need to use the custom
                    // secret if one is configured.
                    'token': customToken !== null && customToken !== void 0 ? customToken : DEFAULT_TOKEN,
                    'commit-message': `${title}\n\n${description}`,
                    'branch': branchName,
                    'title': title,
                    'labels': ((_g = (_f = this.options.workflowOptions) === null || _f === void 0 ? void 0 : _f.labels) === null || _g === void 0 ? void 0 : _g.join(',')) || undefined,
                    'body': description,
                    'author': comitter,
                    'committer': comitter,
                    'signoff': (_h = this.options.signoff) !== null && _h !== void 0 ? _h : true,
                },
            },
        ];
        let writeChecksPermission = false;
        if (this._project.buildWorkflowJobId && upgrade.build) {
            const body = {
                name: this._project.buildWorkflowJobId,
                head_sha: branchName,
                status: 'completed',
                conclusion: context(`needs.${upgrade.jobId}.outputs.${upgrade.buildConclusionOutput}`),
                output: {
                    title: `Created via the ${workflowName} workflow.`,
                    summary: `Action run URL: ${RUN_URL}`,
                },
            };
            steps.push({
                name: 'Update status check',
                if: `steps.${prStepId}.outputs.pull-request-url != \'\'`,
                run: 'curl -i --fail '
                    + '-X POST '
                    + '-H "Accept: application/vnd.github.v3+json" '
                    + `-H "Authorization: token \${GITHUB_TOKEN}" https://api.github.com/repos/${REPO}/check-runs `
                    + `-d '${JSON.stringify(body)}'`,
                env: { GITHUB_TOKEN: DEFAULT_TOKEN },
            });
            // necessary to update status checks
            writeChecksPermission = true;
        }
        return {
            job: {
                name: 'Create Pull Request',
                needs: [upgrade.jobId],
                permissions: {
                    contents: github_1.workflows.JobPermission.WRITE,
                    pullRequests: github_1.workflows.JobPermission.WRITE,
                    checks: writeChecksPermission ? github_1.workflows.JobPermission.WRITE : undefined,
                },
                runsOn: runsOn !== null && runsOn !== void 0 ? runsOn : ['ubuntu-latest'],
                steps: steps,
            },
            jobId: 'pr',
        };
    }
}
exports.UpgradeDependencies = UpgradeDependencies;
_a = JSII_RTTI_SYMBOL_1;
UpgradeDependencies[_a] = { fqn: "projen.javascript.UpgradeDependencies", version: "0.46.3" };
/**
 * (experimental) How often to check for new versions and raise pull requests for version upgrades.
 *
 * @experimental
 */
class UpgradeDependenciesSchedule {
    constructor(cron) {
        this.cron = cron;
    }
    /**
     * (experimental) Create a schedule from a raw cron expression.
     *
     * @experimental
     */
    static expressions(cron) {
        return new UpgradeDependenciesSchedule(cron);
    }
}
exports.UpgradeDependenciesSchedule = UpgradeDependenciesSchedule;
_b = JSII_RTTI_SYMBOL_1;
UpgradeDependenciesSchedule[_b] = { fqn: "projen.javascript.UpgradeDependenciesSchedule", version: "0.46.3" };
/**
 * (experimental) Disables automatic upgrades.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.NEVER = new UpgradeDependenciesSchedule([]);
/**
 * (experimental) At 00:00.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.DAILY = new UpgradeDependenciesSchedule(['0 0 * * *']);
/**
 * (experimental) At 00:00 on every day-of-week from Monday through Friday.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.WEEKDAY = new UpgradeDependenciesSchedule(['0 0 * * 1-5']);
/**
 * (experimental) At 00:00 on Monday.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.WEEKLY = new UpgradeDependenciesSchedule(['0 0 * * 1']);
/**
 * (experimental) At 00:00 on day-of-month 1.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.MONTHLY = new UpgradeDependenciesSchedule(['0 0 1 * *']);
//# sourceMappingURL=data:application/json;base64,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