"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const component_1 = require("../component");
const render_options_1 = require("./render-options");
/**
 * (experimental) Sets up a javascript project to use TypeScript for projenrc.
 *
 * @experimental
 */
class Projenrc extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b;
        super(project);
        this.rcfile = (_b = options.filename) !== null && _b !== void 0 ? _b : '.projenrc.js';
        // this is the task projen executes when running `projen`
        project.defaultTask.exec(`node ${this.rcfile}`);
        this.generateProjenrc();
    }
    generateProjenrc() {
        const rcfile = path_1.resolve(this.project.outdir, this.rcfile);
        if (fs_1.existsSync(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.initProject;
        if (!bootstrap) {
            return;
        }
        const parts = bootstrap.fqn.split('.');
        const moduleName = parts[0];
        const importName = parts[1];
        const className = parts.slice(1).join('.');
        const { renderedOptions, imports } = render_options_1.renderJavaScriptOptions({
            comments: bootstrap.comments,
            args: bootstrap.args,
            type: bootstrap.type,
        });
        imports.add(importName);
        const lines = new Array();
        lines.push(`const { ${[...imports].sort().join(', ')} } = require("${moduleName}");`);
        lines.push();
        lines.push(`const project = new ${className}(${renderedOptions});`);
        lines.push();
        lines.push('project.synth();');
        fs_1.writeFileSync(rcfile, lines.join('\n'));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.javascript.Projenrc", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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