import { Component } from '../component';
import { NodeProject } from '../javascript';
/**
 * (experimental) Options to configure the local NPM config.
 *
 * @experimental
 */
export interface NpmConfigOptions {
    /**
     * (experimental) URL of the registry mirror to use.
     *
     * You can change this or add scoped registries using the addRegistry method
     *
     * @default - use npmjs default registry
     * @experimental
     */
    readonly registry?: string;
}
/**
 * (experimental) File representing the local NPM config in .npmrc.
 *
 * @experimental
 */
export declare class NpmConfig extends Component {
    /**
     * The config object. This object can be mutated until the project is
     * synthesized.
     */
    private readonly config;
    /**
     * @experimental
     */
    constructor(project: NodeProject, options?: NpmConfigOptions);
    /**
     * (experimental) configure a scoped registry.
     *
     * @param url the URL of the registry to use.
     * @param scope the scope the registry is used for;
     * @experimental
     */
    addRegistry(url: string, scope?: string): void;
    /**
     * (experimental) configure a generic property.
     *
     * @param name the name of the property.
     * @param value the value of the property.
     * @experimental
     */
    addConfig(name: string, value: string): void;
}
