"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bundler = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
const util_1 = require("./util");
/**
 * (experimental) Adds support for bundling JavaScript applications and dependencies into a single file.
 *
 * In the future, this will also supports bundling websites.
 *
 * @experimental
 */
class Bundler extends component_1.Component {
    /**
     * (experimental) Creates a `Bundler`.
     *
     * @experimental
     */
    constructor(project, options = {}) {
        var _b, _c;
        super(project);
        this.esbuildVersion = options.esbuildVersion;
        this.bundledir = (_b = options.assetsDir) !== null && _b !== void 0 ? _b : 'assets';
        this.addToPreCompile = (_c = options.addToPreCompile) !== null && _c !== void 0 ? _c : true;
    }
    /**
     * (experimental) Returns the `Bundler` instance associated with a project or `undefined` if there is no Bundler.
     *
     * @param project The project.
     * @returns A bundler
     * @experimental
     */
    static of(project) {
        const isBundler = (o) => o instanceof Bundler;
        return project.components.find(isBundler);
    }
    /**
     * (experimental) Gets or creates the singleton "bundle" task of the project.
     *
     * If the project doesn't have a "bundle" task, it will be created and spawned
     * during the pre-compile phase.
     *
     * @experimental
     */
    get bundleTask() {
        if (!this._task) {
            this.addBundlingSupport();
            this._task = this.project.tasks.addTask('bundle', {
                description: 'Prepare assets',
            });
            // install the bundle task into the pre-compile phase.
            if (this.addToPreCompile) {
                this.project.preCompileTask.spawn(this._task);
            }
        }
        return this._task;
    }
    /**
     * (experimental) Adds a task to the project which bundles a specific entrypoint and all of its dependencies into a single javascript output file.
     *
     * @param entrypoint The relative path of the artifact within the project.
     * @param options Bundling options.
     * @experimental
     */
    addBundle(entrypoint, options) {
        var _b, _c, _d;
        const name = util_1.renderBundleName(entrypoint);
        const outfile = path_1.join(this.bundledir, name, 'index.js');
        const args = [
            'esbuild',
            '--bundle',
            entrypoint,
            `--target="${options.target}"`,
            `--platform="${options.platform}"`,
            `--outfile="${outfile}"`,
        ];
        for (const x of (_b = options.externals) !== null && _b !== void 0 ? _b : []) {
            args.push(`--external:${x}`);
        }
        const sourcemap = (_c = options.sourcemap) !== null && _c !== void 0 ? _c : false;
        if (sourcemap) {
            args.push('--sourcemap');
        }
        const bundleTask = this.project.addTask(`bundle:${name}`, {
            description: `Create a JavaScript bundle from ${entrypoint}`,
            exec: args.join(' '),
        });
        this.bundleTask.spawn(bundleTask);
        let watchTask;
        const watch = (_d = options.watchTask) !== null && _d !== void 0 ? _d : true;
        if (watch) {
            watchTask = this.project.addTask(`bundle:${name}:watch`, {
                description: `Continuously update the JavaScript bundle from ${entrypoint}`,
                exec: `${args.join(' ')} --watch`,
            });
        }
        return {
            bundleTask: bundleTask,
            watchTask: watchTask,
            outfile: outfile,
        };
    }
    /**
     * Add bundling support to a project. This is called implicitly when
     * `bundleTask` is referenced first. It adds the dependency on `esbuild`,
     * gitignore/npmignore, etc.
     */
    addBundlingSupport() {
        const ignoreEntry = `/${this.bundledir}/`;
        this.project.addGitIgnore(ignoreEntry);
        this.project.addPackageIgnore(`!${ignoreEntry}`); // include in tarball
        const dep = this.esbuildVersion ? `esbuild@${this.esbuildVersion}` : 'esbuild';
        this.project.deps.addDependency(dep, dependencies_1.DependencyType.BUILD);
    }
}
exports.Bundler = Bundler;
_a = JSII_RTTI_SYMBOL_1;
Bundler[_a] = { fqn: "projen.javascript.Bundler", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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