import { Component } from '../component';
import { Project } from '../project';
import { Task } from '../task';
/**
 * (experimental) Options for `Bundler`.
 *
 * @experimental
 */
export interface BundlerOptions {
    /**
     * (experimental) The semantic version requirement for `esbuild`.
     *
     * @default - no specific version (implies latest)
     * @experimental
     */
    readonly esbuildVersion?: string;
    /**
     * (experimental) Output directory for all bundles.
     *
     * @default "assets"
     * @experimental
     */
    readonly assetsDir?: string;
    /**
     * (experimental) Install the `bundle` command as a pre-compile phase.
     *
     * @default true
     * @experimental
     */
    readonly addToPreCompile?: boolean;
}
/**
 * (experimental) Adds support for bundling JavaScript applications and dependencies into a single file.
 *
 * In the future, this will also supports bundling websites.
 *
 * @experimental
 */
export declare class Bundler extends Component {
    /**
     * (experimental) Returns the `Bundler` instance associated with a project or `undefined` if there is no Bundler.
     *
     * @param project The project.
     * @returns A bundler
     * @experimental
     */
    static of(project: Project): Bundler | undefined;
    /**
     * (experimental) The semantic version requirement for `esbuild` (if defined).
     *
     * @experimental
     */
    readonly esbuildVersion: string | undefined;
    /**
     * (experimental) Root bundle directory.
     *
     * @experimental
     */
    readonly bundledir: string;
    private _task;
    private readonly addToPreCompile;
    /**
     * (experimental) Creates a `Bundler`.
     *
     * @experimental
     */
    constructor(project: Project, options?: BundlerOptions);
    /**
     * (experimental) Gets or creates the singleton "bundle" task of the project.
     *
     * If the project doesn't have a "bundle" task, it will be created and spawned
     * during the pre-compile phase.
     *
     * @experimental
     */
    get bundleTask(): Task;
    /**
     * (experimental) Adds a task to the project which bundles a specific entrypoint and all of its dependencies into a single javascript output file.
     *
     * @param entrypoint The relative path of the artifact within the project.
     * @param options Bundling options.
     * @experimental
     */
    addBundle(entrypoint: string, options: AddBundleOptions): Bundle;
    /**
     * Add bundling support to a project. This is called implicitly when
     * `bundleTask` is referenced first. It adds the dependency on `esbuild`,
     * gitignore/npmignore, etc.
     */
    private addBundlingSupport;
}
/**
 * @experimental
 */
export interface Bundle {
    /**
     * (experimental) The task that produces this bundle.
     *
     * @experimental
     */
    readonly bundleTask: Task;
    /**
     * (experimental) The "watch" task for this bundle.
     *
     * @experimental
     */
    readonly watchTask?: Task;
    /**
     * (experimental) Location of the output file (relative to project root).
     *
     * @experimental
     */
    readonly outfile: string;
}
/**
 * (experimental) Options for bundling.
 *
 * @experimental
 */
export interface BundlingOptions {
    /**
     * (experimental) You can mark a file or a package as external to exclude it from your build.
     *
     * Instead of being bundled, the import will be preserved (using require for
     * the iife and cjs formats and using import for the esm format) and will be
     * evaluated at run time instead.
     *
     * This has several uses. First of all, it can be used to trim unnecessary
     * code from your bundle for a code path that you know will never be executed.
     * For example, a package may contain code that only runs in node but you will
     * only be using that package in the browser. It can also be used to import
     * code in node at run time from a package that cannot be bundled. For
     * example, the fsevents package contains a native extension, which esbuild
     * doesn't support.
     *
     * @default []
     * @experimental
     */
    readonly externals?: string[];
    /**
     * (experimental) Include a source map in the bundle.
     *
     * @default false
     * @experimental
     */
    readonly sourcemap?: boolean;
    /**
     * (experimental) In addition to the `bundle:xyz` task, creates `bundle:xyz:watch` task which will invoke the same esbuild command with the `--watch` flag.
     *
     * This can be used
     * to continusouly watch for changes.
     *
     * @default true
     * @experimental
     */
    readonly watchTask?: boolean;
}
/**
 * (experimental) Options for `addBundle()`.
 *
 * @experimental
 */
export interface AddBundleOptions extends BundlingOptions {
    /**
     * (experimental) esbuild target.
     *
     * @experimental
     * @example
     *
     * "node12"
     */
    readonly target: string;
    /**
     * (experimental) esbuild platform.
     *
     * @experimental
     * @example
     *
     * "node"
     */
    readonly platform: string;
}
