"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Junit = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const component_1 = require("../component");
const sample_file_1 = require("../sample-file");
const TESTDIR = path_1.join('src', 'test', 'java');
/**
 * (experimental) Implements JUnit-based testing.
 *
 * @experimental
 */
class Junit extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b, _c;
        super(project);
        const pom = options.pom;
        const version = (_b = options.version) !== null && _b !== void 0 ? _b : '5.7.0';
        pom.addTestDependency(`org.junit.jupiter/junit-jupiter-api@${version}`);
        pom.addTestDependency(`org.junit.jupiter/junit-jupiter-engine@${version}`);
        project.testTask.exec('mvn test');
        const javaPackage = (_c = options.sampleJavaPackage) !== null && _c !== void 0 ? _c : 'org.acme';
        const javaPackagePath = javaPackage.split('.');
        new sample_file_1.SampleDir(project, path_1.join(TESTDIR, ...javaPackagePath), {
            files: {
                'MyTest.java': [
                    `package ${javaPackage};`,
                    '',
                    'import org.junit.jupiter.api.Test;',
                    '',
                    'public class MyTest {',
                    '  @Test',
                    '  public void testHello() {',
                    '    System.out.println("Hello, world!");',
                    '  }',
                    '}',
                ].join('\n'),
            },
        });
    }
}
exports.Junit = Junit;
_a = JSII_RTTI_SYMBOL_1;
Junit[_a] = { fqn: "projen.java.Junit", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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