"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Gitpod = exports.GitpodPortVisibility = exports.GitpodOnOpen = exports.GitpodOpenIn = exports.GitpodOpenMode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const yaml_1 = require("./yaml");
/**
  * Relative path of Gitpod file to generate
  */
const GITPOD_FILE = '.gitpod.yml';
/**
 * (experimental) Configure how the terminal should be opened relative to the previous task.
 *
 * @experimental
 */
var GitpodOpenMode;
(function (GitpodOpenMode) {
    GitpodOpenMode["TAB_AFTER"] = "tab-after";
    GitpodOpenMode["TAB_BEFORE"] = "tab-before";
    GitpodOpenMode["SPLIT_RIGHT"] = "split-right";
    GitpodOpenMode["SPLIT_LEFT"] = "split-left";
    GitpodOpenMode["SPLIT_TOP"] = "split-top";
    GitpodOpenMode["SPLIT_BOTTOM"] = "split-bottom";
})(GitpodOpenMode = exports.GitpodOpenMode || (exports.GitpodOpenMode = {}));
/**
 * (experimental) Configure where in the IDE the terminal should be opened.
 *
 * @experimental
 */
var GitpodOpenIn;
(function (GitpodOpenIn) {
    GitpodOpenIn["BOTTOM"] = "bottom";
    GitpodOpenIn["LEFT"] = "left";
    GitpodOpenIn["RIGHT"] = "right";
    GitpodOpenIn["MAIN"] = "main";
})(GitpodOpenIn = exports.GitpodOpenIn || (exports.GitpodOpenIn = {}));
/**
 * (experimental) What to do when a service on a port is detected.
 *
 * @experimental
 */
var GitpodOnOpen;
(function (GitpodOnOpen) {
    GitpodOnOpen["OPEN_BROWSER"] = "open-browser";
    GitpodOnOpen["OPEN_PREVIEW"] = "open-preview";
    GitpodOnOpen["NOTIFY"] = "notify";
    GitpodOnOpen["IGNORE"] = "ignore";
})(GitpodOnOpen = exports.GitpodOnOpen || (exports.GitpodOnOpen = {}));
/**
 * (experimental) Whether the port visibility should be private or public.
 *
 * @experimental
 */
var GitpodPortVisibility;
(function (GitpodPortVisibility) {
    GitpodPortVisibility["PUBLIC"] = "public";
    GitpodPortVisibility["PRIVATE"] = "private";
})(GitpodPortVisibility = exports.GitpodPortVisibility || (exports.GitpodPortVisibility = {}));
/**
 * (experimental) The Gitpod component which emits .gitpod.yml.
 *
 * @experimental
 */
class Gitpod extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        super(project);
        this.tasks = new Array();
        this.ports = new Array();
        this.vscodeExtensions = new Array();
        this.dockerImage = options === null || options === void 0 ? void 0 : options.dockerImage;
        if (options === null || options === void 0 ? void 0 : options.tasks) {
            for (const task of options.tasks) {
                this.addTasks(task);
            }
        }
        if (options === null || options === void 0 ? void 0 : options.prebuilds) {
            this.addPrebuilds(options.prebuilds);
        }
        if (options === null || options === void 0 ? void 0 : options.ports) {
            this.addPorts(...options.ports);
        }
        if (options === null || options === void 0 ? void 0 : options.vscodeExtensions) {
            this.addVscodeExtensions(...options.vscodeExtensions);
        }
        this.config = {
            image: () => this.renderDockerImage(),
            tasks: this.tasks,
            github: () => this.renderPrebuilds(),
            ports: this.ports,
            vscode: {
                extensions: this.vscodeExtensions,
            },
        };
        new yaml_1.YamlFile(this.project, GITPOD_FILE, { obj: this.config, omitEmpty: true });
    }
    /**
     * (experimental) Add a custom Docker image or Dockerfile for the container.
     *
     * @param image The Docker image.
     * @experimental
     */
    addDockerImage(image) {
        if (this.dockerImage) {
            throw new Error('dockerImage cannot be redefined.');
        }
        this.dockerImage = image;
    }
    /**
     * (experimental) Add tasks to run when gitpod starts.
     *
     * By default, all tasks will be run in parallel. To run tasks in sequence,
     * create a new `Task` and specify the other tasks as subtasks.
     *
     * @param tasks The new tasks.
     * @experimental
     */
    addTasks(...tasks) {
        this.tasks.push(...tasks.map(task => ({
            name: task.name,
            command: `npx projen ${task.name}`,
        })));
    }
    /**
     * (experimental) Add a prebuilds configuration for the Gitpod App.
     *
     * @param config The configuration.
     * @experimental
     */
    addPrebuilds(config) {
        this.prebuilds = config;
    }
    /**
     * (experimental) Add a task with more granular options.
     *
     * By default, all tasks will be run in parallel. To run tasks in sequence,
     * create a new `Task` and set the other tasks as subtasks.
     *
     * @param options The task parameters.
     * @experimental
     */
    addCustomTask(options) {
        this.tasks.push({
            name: options.name,
            command: options.command,
            openMode: options.openMode,
            openIn: options.openIn,
            before: options.before,
            init: options.init,
            prebuild: options.prebuild,
        });
    }
    /**
     * (experimental) Add ports that should be exposed (forwarded) from the container.
     *
     * @param ports The new ports.
     * @experimental
     */
    addPorts(...ports) {
        this.ports.push(...ports.map(port => ({ port: port })));
    }
    /**
     * (experimental) Add a list of VSCode extensions that should be automatically installed in the container.
     *
     * These must be in the format defined in the Open VSX registry.
     *
     * @param extensions The extension IDs.
     * @see https://www.gitpod.io/docs/vscode-extensions/
     * @experimental
     * @example
     *
     * 'scala-lang.scala@0.3.9:O5XmjwY5Gz+0oDZAmqneJw=='
     */
    addVscodeExtensions(...extensions) {
        this.vscodeExtensions.push(...extensions);
    }
    renderDockerImage() {
        var _b, _c;
        if ((_b = this.dockerImage) === null || _b === void 0 ? void 0 : _b.image) {
            return this.dockerImage.image;
        }
        else if ((_c = this.dockerImage) === null || _c === void 0 ? void 0 : _c.dockerFile) {
            return {
                file: this.dockerImage.dockerFile,
            };
        }
        else {
            return undefined;
        }
    }
    renderPrebuilds() {
        if (this.prebuilds) {
            return {
                prebuilds: this.prebuilds,
            };
        }
        else {
            return undefined;
        }
    }
}
exports.Gitpod = Gitpod;
_a = JSII_RTTI_SYMBOL_1;
Gitpod[_a] = { fqn: "projen.Gitpod", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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