/**
 * (experimental) A GitHub Workflow job definition.
 *
 * @experimental
 */
export interface Job {
    /**
     * (experimental) The type of machine to run the job on.
     *
     * The machine can be either a
     * GitHub-hosted runner or a self-hosted runner.
     *
     * @experimental
     * @example
     *
     * ["ubuntu-latest"]
     */
    readonly runsOn: string[];
    /**
     * (experimental) A job contains a sequence of tasks called steps.
     *
     * Steps can run commands,
     * run setup tasks, or run an action in your repository, a public repository,
     * or an action published in a Docker registry. Not all steps run actions,
     * but all actions run as a step. Each step runs in its own process in the
     * runner environment and has access to the workspace and filesystem.
     * Because steps run in their own process, changes to environment variables
     * are not preserved between steps. GitHub provides built-in steps to set up
     * and complete a job.
     *
     * @experimental
     */
    readonly steps: JobStep[];
    /**
     * (experimental) The name of the job displayed on GitHub.
     *
     * @experimental
     */
    readonly name?: string;
    /**
     * (experimental) Identifies any jobs that must complete successfully before this job will run.
     *
     * It can be a string or array of strings. If a job fails, all jobs
     * that need it are skipped unless the jobs use a conditional expression
     * that causes the job to continue.
     *
     * @experimental
     */
    readonly needs?: string[];
    /**
     * (experimental) You can modify the default permissions granted to the GITHUB_TOKEN, adding or removing access as required, so that you only allow the minimum required access.
     *
     * Use `{ contents: READ }` if your job only needs to clone code.
     *
     * This is intentionally a required field since it is required in order to
     * allow workflows to run in GitHub repositories with restricted default
     * access.
     *
     * @see https://docs.github.com/en/actions/reference/authentication-in-a-workflow#permissions-for-the-github_token
     * @experimental
     */
    readonly permissions: JobPermissions;
    /**
     * (experimental) The environment that the job references.
     *
     * All environment protection rules
     * must pass before a job referencing the environment is sent to a runner.
     *
     * @see https://docs.github.com/en/actions/reference/environments
     * @experimental
     */
    readonly environment?: unknown;
    /**
     * (experimental) Concurrency ensures that only a single job or workflow using the same concurrency group will run at a time.
     *
     * A concurrency group can be any
     * string or expression. The expression can use any context except for the
     * secrets context.
     *
     * @experimental
     */
    readonly concurrency?: unknown;
    /**
     * (experimental) A map of outputs for a job.
     *
     * Job outputs are available to all downstream
     * jobs that depend on this job.
     *
     * @experimental
     */
    readonly outputs?: Record<string, JobStepOutput>;
    /**
     * (experimental) A map of environment variables that are available to all steps in the job.
     *
     * You can also set environment variables for the entire workflow or an
     * individual step.
     *
     * @experimental
     */
    readonly env?: Record<string, string>;
    /**
     * (experimental) A map of default settings that will apply to all steps in the job.
     *
     * You
     * can also set default settings for the entire workflow.
     *
     * @experimental
     */
    readonly defaults?: JobDefaults;
    /**
     * (experimental) You can use the if conditional to prevent a job from running unless a condition is met.
     *
     * You can use any supported context and expression to
     * create a conditional.
     *
     * @experimental
     */
    readonly if?: string;
    /**
     * (experimental) The maximum number of minutes to let a job run before GitHub automatically cancels it.
     *
     * @default 360
     * @experimental
     */
    readonly timeoutMinutes?: number;
    /**
     * (experimental) A strategy creates a build matrix for your jobs.
     *
     * You can define different
     * variations to run each job in.
     *
     * @experimental
     */
    readonly strategy?: JobStrategy;
    /**
     * (experimental) Prevents a workflow run from failing when a job fails.
     *
     * Set to true to
     * allow a workflow run to pass when this job fails.
     *
     * @experimental
     */
    readonly continueOnError?: boolean;
    /**
     * (experimental) A container to run any steps in a job that don't already specify a container.
     *
     * If you have steps that use both script and container actions,
     * the container actions will run as sibling containers on the same network
     * with the same volume mounts.
     *
     * @experimental
     */
    readonly container?: ContainerOptions;
    /**
     * (experimental) Used to host service containers for a job in a workflow.
     *
     * Service
     * containers are useful for creating databases or cache services like Redis.
     * The runner automatically creates a Docker network and manages the life
     * cycle of the service containers.
     *
     * @experimental
     */
    readonly services?: Record<string, ContainerOptions>;
    /**
     * (experimental) Tools required for this job.
     *
     * Traslates into `actions/setup-xxx` steps at
     * the beginning of the job.
     *
     * @experimental
     */
    readonly tools?: Tools;
}
/**
 * (experimental) Supported tools.
 *
 * @experimental
 */
export interface Tools {
    /**
     * (experimental) Setup java (temurin distribution).
     *
     * @default - not installed
     * @experimental
     */
    readonly java?: ToolRequirement;
    /**
     * (experimental) Setup python.
     *
     * @default - not installed
     * @experimental
     */
    readonly python?: ToolRequirement;
    /**
     * (experimental) Setup golang.
     *
     * @default - not installed
     * @experimental
     */
    readonly go?: ToolRequirement;
    /**
     * (experimental) Setup node.js.
     *
     * @default - not installed
     * @experimental
     */
    readonly node?: ToolRequirement;
    /**
     * (experimental) Setup .NET Core.
     *
     * @default - not installed
     * @experimental
     */
    readonly dotnet?: ToolRequirement;
}
/**
 * (experimental) Version requirement for tools.
 *
 * @experimental
 */
export interface ToolRequirement {
    /**
     * @experimental
     */
    readonly version: string;
}
/**
 * (experimental) The available scopes and access values for workflow permissions.
 *
 * If you
 * specify the access for any of these scopes, all those that are not
 * specified are set to `JobPermission.NONE`, instead of the default behavior
 * when none is specified.
 *
 * @experimental
 */
export interface JobPermissions {
    /**
     * @experimental
     */
    readonly actions?: JobPermission;
    /**
     * @experimental
     */
    readonly checks?: JobPermission;
    /**
     * @experimental
     */
    readonly contents?: JobPermission;
    /**
     * @experimental
     */
    readonly deployments?: JobPermission;
    /**
     * @experimental
     */
    readonly issues?: JobPermission;
    /**
     * @experimental
     */
    readonly packages?: JobPermission;
    /**
     * @experimental
     */
    readonly pullRequests?: JobPermission;
    /**
     * @experimental
     */
    readonly repositoryProjects?: JobPermission;
    /**
     * @experimental
     */
    readonly securityEvents?: JobPermission;
    /**
     * @experimental
     */
    readonly statuses?: JobPermission;
}
/**
 * (experimental) Access level for workflow permission scopes.
 *
 * @experimental
 */
export declare enum JobPermission {
    /**
     * (experimental) Read-only access.
     *
     * @experimental
     */
    READ = "read",
    /**
     * (experimental) Read-write access.
     *
     * @experimental
     */
    WRITE = "write",
    /**
     * (experimental) No access at all.
     *
     * @experimental
     */
    NONE = "none"
}
/**
 * (experimental) An output binding for a job.
 *
 * @experimental
 */
export interface JobStepOutput {
    /**
     * (experimental) The ID of the step that exposes the output.
     *
     * @experimental
     */
    readonly stepId: string;
    /**
     * (experimental) The name of the job output that is being bound.
     *
     * @experimental
     */
    readonly outputName: string;
}
/**
 * (experimental) Default settings for all steps in the job.
 *
 * @experimental
 */
export interface JobDefaults {
    /**
     * (experimental) Default run settings.
     *
     * @experimental
     */
    readonly run?: RunSettings;
}
/**
 * (experimental) Run settings for a job.
 *
 * @experimental
 */
export interface RunSettings {
    /**
     * (experimental) Which shell to use for running the step.
     *
     * @experimental
     * @example
     *
     * "bash"
     */
    readonly shell?: string;
    /**
     * (experimental) Working directory to use when running the step.
     *
     * @experimental
     */
    readonly workingDirectory?: string;
}
/**
 * (experimental) A job step.
 *
 * @experimental
 */
export interface JobStep {
    /**
     * (experimental) A unique identifier for the step.
     *
     * You can use the id to reference the
     * step in contexts.
     *
     * @experimental
     */
    readonly id?: string;
    /**
     * (experimental) You can use the if conditional to prevent a job from running unless a condition is met.
     *
     * You can use any supported context and expression to
     * create a conditional.
     *
     * @experimental
     */
    readonly if?: string;
    /**
     * (experimental) A name for your step to display on GitHub.
     *
     * @experimental
     */
    readonly name?: string;
    /**
     * (experimental) Selects an action to run as part of a step in your job.
     *
     * An action is a
     * reusable unit of code. You can use an action defined in the same
     * repository as the workflow, a public repository, or in a published Docker
     * container image.
     *
     * @experimental
     */
    readonly uses?: string;
    /**
     * (experimental) Runs command-line programs using the operating system's shell.
     *
     * If you do
     * not provide a name, the step name will default to the text specified in
     * the run command.
     *
     * @experimental
     */
    readonly run?: string;
    /**
     * (experimental) A map of the input parameters defined by the action.
     *
     * Each input parameter
     * is a key/value pair. Input parameters are set as environment variables.
     * The variable is prefixed with INPUT_ and converted to upper case.
     *
     * @experimental
     */
    readonly with?: Record<string, any>;
    /**
     * (experimental) Sets environment variables for steps to use in the runner environment.
     *
     * You can also set environment variables for the entire workflow or a job.
     *
     * @experimental
     */
    readonly env?: Record<string, string>;
    /**
     * (experimental) Prevents a job from failing when a step fails.
     *
     * Set to true to allow a job
     * to pass when this step fails.
     *
     * @experimental
     */
    readonly continueOnError?: boolean;
    /**
     * (experimental) The maximum number of minutes to run the step before killing the process.
     *
     * @experimental
     */
    readonly timeoutMinutes?: number;
}
/**
 * (experimental) A strategy creates a build matrix for your jobs.
 *
 * You can define different
 * variations to run each job in.
 *
 * @experimental
 */
export interface JobStrategy {
    /**
     * (experimental) You can define a matrix of different job configurations.
     *
     * A matrix allows
     * you to create multiple jobs by performing variable substitution in a
     * single job definition. For example, you can use a matrix to create jobs
     * for more than one supported version of a programming language, operating
     * system, or tool. A matrix reuses the job's configuration and creates a
     * job for each matrix you configure.
     *
     * A job matrix can generate a maximum of 256 jobs per workflow run. This
     * limit also applies to self-hosted runners.
     *
     * @experimental
     */
    readonly matrix?: JobMatrix;
    /**
     * (experimental) When set to true, GitHub cancels all in-progress jobs if any matrix job fails.
     *
     * Default: true
     *
     * @experimental
     */
    readonly failFast?: boolean;
    /**
     * (experimental) The maximum number of jobs that can run simultaneously when using a matrix job strategy.
     *
     * By default, GitHub will maximize the number of jobs
     * run in parallel depending on the available runners on GitHub-hosted
     * virtual machines.
     *
     * @experimental
     */
    readonly maxParallel?: number;
}
/**
 * (experimental) A job matrix.
 *
 * @experimental
 */
export interface JobMatrix {
    /**
     * (experimental) Each option you define in the matrix has a key and value.
     *
     * The keys you
     * define become properties in the matrix context and you can reference the
     * property in other areas of your workflow file. For example, if you define
     * the key os that contains an array of operating systems, you can use the
     * matrix.os property as the value of the runs-on keyword to create a job
     * for each operating system.
     *
     * @experimental
     */
    readonly domain?: Record<string, string[]>;
    /**
     * (experimental) You can add additional configuration options to a build matrix job that already exists.
     *
     * For example, if you want to use a specific version of npm
     * when the job that uses windows-latest and version 8 of node runs, you can
     * use include to specify that additional option.
     *
     * @experimental
     */
    readonly include?: Array<Record<string, string>>;
    /**
     * (experimental) You can remove a specific configurations defined in the build matrix using the exclude option.
     *
     * Using exclude removes a job defined by the
     * build matrix.
     *
     * @experimental
     */
    readonly exclude?: Array<Record<string, string>>;
}
/**
 * (experimental) Options petaining to container environments.
 *
 * @experimental
 */
export interface ContainerOptions {
    /**
     * (experimental) The Docker image to use as the container to run the action.
     *
     * The value can
     * be the Docker Hub image name or a registry name.
     *
     * @experimental
     */
    readonly image: string;
    /**
     * (experimental) f the image's container registry requires authentication to pull the image, you can use credentials to set a map of the username and password.
     *
     * The credentials are the same values that you would provide to the docker
     * login command.
     *
     * @experimental
     */
    readonly credentials?: ContainerCredentials;
    /**
     * (experimental) Sets a map of environment variables in the container.
     *
     * @experimental
     */
    readonly env?: Record<string, string>;
    /**
     * (experimental) Sets an array of ports to expose on the container.
     *
     * @experimental
     */
    readonly ports?: number[];
    /**
     * (experimental) Sets an array of volumes for the container to use.
     *
     * You can use volumes to
     * share data between services or other steps in a job. You can specify
     * named Docker volumes, anonymous Docker volumes, or bind mounts on the
     * host.
     *
     * To specify a volume, you specify the source and destination path:
     * `<source>:<destinationPath>`.
     *
     * @experimental
     */
    readonly volumes?: string[];
    /**
     * (experimental) Additional Docker container resource options.
     *
     * @see https://docs.docker.com/engine/reference/commandline/create/#options
     * @experimental
     */
    readonly options?: string[];
}
/**
 * (experimental) Credentials to use to authenticate to Docker registries.
 *
 * @experimental
 */
export interface ContainerCredentials {
    /**
     * (experimental) The username.
     *
     * @experimental
     */
    readonly username: string;
    /**
     * (experimental) The password.
     *
     * @experimental
     */
    readonly password: string;
}
/**
 * (experimental) The set of available triggers for GitHub Workflows.
 *
 * @see https://docs.github.com/en/actions/reference/events-that-trigger-workflows
 * @experimental
 */
export interface Triggers {
    /**
     * (experimental) You can schedule a workflow to run at specific UTC times using POSIX cron syntax.
     *
     * Scheduled workflows run on the latest commit on the default or
     * base branch. The shortest interval you can run scheduled workflows is
     * once every 5 minutes.
     *
     * @see https://pubs.opengroup.org/onlinepubs/9699919799/utilities/crontab.html#tag_20_25_07
     * @experimental
     */
    readonly schedule?: CronScheduleOptions[];
    /**
     * (experimental) You can configure custom-defined input properties, default input values, and required inputs for the event directly in your workflow.
     *
     * When the
     * workflow runs, you can access the input values in the github.event.inputs
     * context.
     *
     * @experimental
     */
    readonly workflowDispatch?: WorkflowDispatchOptions;
    /**
     * (experimental) You can use the GitHub API to trigger a webhook event called repository_dispatch when you want to trigger a workflow for activity that happens outside of GitHub.
     *
     * @experimental
     */
    readonly repositoryDispatch?: RepositoryDispatchOptions;
    /**
     * (experimental) Can be called from another workflow.
     *
     * @see https://docs.github.com/en/actions/learn-github-actions/reusing-workflows
     * @experimental
     */
    readonly workflowCall?: WorkflowCallOptions;
    /**
     * (experimental) Runs your workflow anytime the branch_protection_rule event occurs.
     *
     * @experimental
     */
    readonly branchProtectionRule?: BranchProtectionRuleOptions;
    /**
     * (experimental) Runs your workflow anytime the check_run event occurs.
     *
     * @experimental
     */
    readonly checkRun?: CheckRunOptions;
    /**
     * (experimental) Runs your workflow anytime the check_suite event occurs.
     *
     * @experimental
     */
    readonly checkSuite?: CheckSuiteOptions;
    /**
     * (experimental) Runs your workflow anytime someone creates a branch or tag, which triggers the create event.
     *
     * @experimental
     */
    readonly create?: CreateOptions;
    /**
     * (experimental) Runs your workflow anytime someone deletes a branch or tag, which triggers the delete event.
     *
     * @experimental
     */
    readonly delete?: DeleteOptions;
    /**
     * (experimental) Runs your workflow anytime someone creates a deployment, which triggers the deployment event.
     *
     * Deployments created with a commit SHA may not have
     * a Git ref.
     *
     * @experimental
     */
    readonly deployment?: DeploymentOptions;
    /**
     * (experimental) Runs your workflow anytime a third party provides a deployment status, which triggers the deployment_status event.
     *
     * Deployments created with a
     * commit SHA may not have a Git ref.
     *
     * @experimental
     */
    readonly deploymentStatus?: DeploymentStatusOptions;
    /**
     * (experimental) Runs your workflow anytime the discussion event occurs.
     *
     * More than one activity type triggers this event.
     *
     * @see https://docs.github.com/en/graphql/guides/using-the-graphql-api-for-discussions
     * @experimental
     */
    readonly discussion?: DiscussionOptions;
    /**
     * (experimental) Runs your workflow anytime the discussion_comment event occurs.
     *
     * More than one activity type triggers this event.
     *
     * @see https://docs.github.com/en/graphql/guides/using-the-graphql-api-for-discussions
     * @experimental
     */
    readonly discussionComment?: DiscussionCommentOptions;
    /**
     * (experimental) Runs your workflow anytime when someone forks a repository, which triggers the fork event.
     *
     * @experimental
     */
    readonly fork?: ForkOptions;
    /**
     * (experimental) Runs your workflow when someone creates or updates a Wiki page, which triggers the gollum event.
     *
     * @experimental
     */
    readonly gollum?: GollumOptions;
    /**
     * (experimental) Runs your workflow anytime the issue_comment event occurs.
     *
     * @experimental
     */
    readonly issueComment?: IssueCommentOptions;
    /**
     * (experimental) Runs your workflow anytime the issues event occurs.
     *
     * @experimental
     */
    readonly issues?: IssuesOptions;
    /**
     * (experimental) Runs your workflow anytime the label event occurs.
     *
     * @experimental
     */
    readonly label?: LabelOptions;
    /**
     * (experimental) Runs your workflow anytime the milestone event occurs.
     *
     * @experimental
     */
    readonly milestone?: MilestoneOptions;
    /**
     * (experimental) Runs your workflow anytime someone pushes to a GitHub Pages-enabled branch, which triggers the page_build event.
     *
     * @experimental
     */
    readonly pageBuild?: PageBuildOptions;
    /**
     * (experimental) Runs your workflow anytime the project event occurs.
     *
     * @experimental
     */
    readonly project?: ProjectOptions;
    /**
     * (experimental) Runs your workflow anytime the project_card event occurs.
     *
     * @experimental
     */
    readonly projectCard?: ProjectCardOptions;
    /**
     * (experimental) Runs your workflow anytime the project_column event occurs.
     *
     * @experimental
     */
    readonly projectColumn?: ProjectColumnOptions;
    /**
     * (experimental) Runs your workflow anytime someone makes a private repository public, which triggers the public event.
     *
     * @experimental
     */
    readonly public?: PublicOptions;
    /**
     * (experimental) Runs your workflow anytime the pull_request event occurs.
     *
     * @experimental
     */
    readonly pullRequest?: PullRequestOptions;
    /**
     * (experimental) Runs your workflow anytime the pull_request_review event occurs.
     *
     * @experimental
     */
    readonly pullRequestReview?: PullRequestReviewOptions;
    /**
     * (experimental) Runs your workflow anytime a comment on a pull request's unified diff is modified, which triggers the pull_request_review_comment event.
     *
     * @experimental
     */
    readonly pullRequestReviewComment?: PullRequestReviewCommentOptions;
    /**
     * (experimental) This event runs in the context of the base of the pull request, rather than in the merge commit as the pull_request event does.
     *
     * This prevents
     * executing unsafe workflow code from the head of the pull request that
     * could alter your repository or steal any secrets you use in your workflow.
     * This event allows you to do things like create workflows that label and
     * comment on pull requests based on the contents of the event payload.
     *
     * WARNING: The `pull_request_target` event is granted read/write repository
     * token and can access secrets, even when it is triggered from a fork.
     * Although the workflow runs in the context of the base of the pull request,
     * you should make sure that you do not check out, build, or run untrusted
     * code from the pull request with this event. Additionally, any caches
     * share the same scope as the base branch, and to help prevent cache
     * poisoning, you should not save the cache if there is a possibility that
     * the cache contents were altered.
     *
     * @see https://securitylab.github.com/research/github-actions-preventing-pwn-requests
     * @experimental
     */
    readonly pullRequestTarget?: PullRequestTargetOptions;
    /**
     * (experimental) Runs your workflow when someone pushes to a repository branch, which triggers the push event.
     *
     * @experimental
     */
    readonly push?: PushOptions;
    /**
     * (experimental) Runs your workflow anytime a package is published or updated.
     *
     * @experimental
     */
    readonly registryPackage?: RegistryPackageOptions;
    /**
     * (experimental) Runs your workflow anytime the release event occurs.
     *
     * @experimental
     */
    readonly release?: ReleaseOptions;
    /**
     * (experimental) Runs your workflow anytime the status of a Git commit changes, which triggers the status event.
     *
     * @experimental
     */
    readonly status?: StatusOptions;
    /**
     * (experimental) Runs your workflow anytime the watch event occurs.
     *
     * @experimental
     */
    readonly watch?: WatchOptions;
    /**
     * (experimental) This event occurs when a workflow run is requested or completed, and allows you to execute a workflow based on the finished result of another workflow.
     *
     * A workflow run is triggered regardless of the result of the
     * previous workflow.
     *
     * @experimental
     */
    readonly workflowRun?: WorkflowRunOptions;
}
/**
 * (experimental) CRON schedule options.
 *
 * @experimental
 */
export interface CronScheduleOptions {
    /**
     * @see https://pubs.opengroup.org/onlinepubs/9699919799/utilities/crontab.html#tag_20_25_07
     * @experimental
     */
    readonly cron: string;
}
/**
 * (experimental) Repository dispatch options.
 *
 * @experimental
 */
export interface RepositoryDispatchOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: string[];
}
/**
 * (experimental) Branch Protection Rule options.
 *
 * @experimental
 */
export interface BranchProtectionRuleOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'created' | 'edited' | 'deleted'>;
}
/**
 * (experimental) Check run options.
 *
 * @experimental
 */
export interface CheckRunOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'create' | 'rerequested' | 'completed' | 'requested_action'>;
}
/**
 * (experimental) Check suite options.
 *
 * @experimental
 */
export interface CheckSuiteOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'completed' | 'requested' | 'rerequested'>;
}
/**
 * (experimental) Discussion options.
 *
 * @experimental
 */
export interface DiscussionOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'created' | 'edited' | 'transferred' | 'pinned' | 'unpinned' | 'labeled' | 'unlabeled' | 'locked' | 'unlocked' | 'category_changed' | 'answered' | 'unanswered'>;
}
/**
 * (experimental) Discussion comment options.
 *
 * @experimental
 */
export interface DiscussionCommentOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'created' | 'edited' | 'deleted'>;
}
/**
 * (experimental) Issue comment options.
 *
 * @experimental
 */
export interface IssueCommentOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'created' | 'edited' | 'deleted'>;
}
/**
 * (experimental) Issues options.
 *
 * @experimental
 */
export interface IssuesOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'opened' | 'edited' | 'deleted' | 'transferred' | 'pinned' | 'unpinned' | 'closed' | 'reopened' | 'assigned' | 'unassigned' | 'labeled' | 'unlabeled' | 'locked' | 'unlocked' | 'milestoned' | 'demilestoned'>;
}
/**
 * (experimental) label options.
 *
 * @experimental
 */
export interface LabelOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'created' | 'edited' | 'deleted'>;
}
/**
 * (experimental) Milestone options.
 *
 * @experimental
 */
export interface MilestoneOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'created' | 'closed' | 'opened' | 'edited' | 'deleted'>;
}
/**
 * (experimental) Project options.
 *
 * @experimental
 */
export interface ProjectOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'created' | 'updated' | 'closed' | 'reopened' | 'edited' | 'deleted'>;
}
/**
 * (experimental) Project card options.
 *
 * @experimental
 */
export interface ProjectCardOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'created' | 'moved' | 'converted' | 'edited' | 'deleted'>;
}
/**
 * (experimental) Probject column options.
 *
 * @experimental
 */
export interface ProjectColumnOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'created' | 'updated' | 'moved' | 'deleted'>;
}
/**
 * (experimental) Pull request options.
 *
 * @experimental
 */
export interface PullRequestOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'assigned' | 'unassigned' | 'labeled' | 'unlabeled' | 'opened' | 'edited' | 'closed' | 'reopened' | 'synchronize' | 'ready_for_review' | 'locked' | 'unlocked' | 'review_requested' | 'review_request_removed'>;
}
/**
 * (experimental) Pull request review options.
 *
 * @experimental
 */
export interface PullRequestReviewOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'submitted' | 'edited' | 'dismissed'>;
}
/**
 * (experimental) Pull request review comment options.
 *
 * @experimental
 */
export interface PullRequestReviewCommentOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'created' | 'edited' | 'deleted'>;
}
/**
 * (experimental) Pull request target options.
 *
 * @experimental
 */
export interface PullRequestTargetOptions extends PushOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'assigned' | 'unassigned' | 'labeled' | 'unlabeled' | 'opened' | 'edited' | 'closed' | 'reopened' | 'synchronize' | 'ready_for_review' | 'locked' | 'unlocked' | 'review_requested' | 'review_request_removed'>;
}
/**
 * (experimental) Options for push-like events.
 *
 * @experimental
 */
export interface PushOptions {
    /**
     * (experimental) When using the push and pull_request events, you can configure a workflow to run on specific branches or tags.
     *
     * For a pull_request event, only
     * branches and tags on the base are evaluated. If you define only tags or
     * only branches, the workflow won't run for events affecting the undefined
     * Git ref.
     *
     * @see https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions#filter-pattern-cheat-sheet
     * @experimental
     */
    readonly branches?: string[];
    /**
     * (experimental) When using the push and pull_request events, you can configure a workflow to run on specific branches or tags.
     *
     * For a pull_request event, only
     * branches and tags on the base are evaluated. If you define only tags or
     * only branches, the workflow won't run for events affecting the undefined
     * Git ref.
     *
     * @see https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions#filter-pattern-cheat-sheet
     * @experimental
     */
    readonly tags?: string[];
    /**
     * (experimental) When using the push and pull_request events, you can configure a workflow to run when at least one file does not match paths-ignore or at least one modified file matches the configured paths.
     *
     * Path filters are not
     * evaluated for pushes to tags.
     *
     * @see https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions#filter-pattern-cheat-sheet
     * @experimental
     */
    readonly paths?: string[];
}
/**
 * (experimental) Registry package options.
 *
 * @experimental
 */
export interface RegistryPackageOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'published' | 'updated'>;
}
/**
 * (experimental) Release options.
 *
 * @experimental
 */
export interface ReleaseOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'published' | 'unpublished' | 'created' | 'edited' | 'deleted' | 'prereleased' | 'released'>;
}
/**
 * (experimental) Watch options.
 *
 * @experimental
 */
export interface WatchOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'started'>;
}
/**
 * (experimental) Workflow run options.
 *
 * @experimental
 */
export interface WorkflowRunOptions {
    /**
     * (experimental) Which activity types to trigger on.
     *
     * @experimental
     * @defaults - all activity types
     */
    readonly types?: Array<'completed' | 'requested'>;
}
/**
 * (experimental) The Workflow dispatch event accepts no options.
 *
 * @experimental
 */
export interface WorkflowDispatchOptions {
}
/**
 * (experimental) The Workflow Call event accepts no options.
 *
 * @experimental
 */
export interface WorkflowCallOptions {
}
/**
 * (experimental) The Create event accepts no options.
 *
 * @experimental
 */
export interface CreateOptions {
}
/**
 * (experimental) The Delete event accepts no options.
 *
 * @experimental
 */
export interface DeleteOptions {
}
/**
 * (experimental) The Deployment event accepts no options.
 *
 * @experimental
 */
export interface DeploymentOptions {
}
/**
 * (experimental) The Deployment status event accepts no options.
 *
 * @experimental
 */
export interface DeploymentStatusOptions {
}
/**
 * (experimental) The Fork event accepts no options.
 *
 * @experimental
 */
export interface ForkOptions {
}
/**
 * (experimental) The Gollum event accepts no options.
 *
 * @experimental
 */
export interface GollumOptions {
}
/**
 * (experimental) The Page build event accepts no options.
 *
 * @experimental
 */
export interface PageBuildOptions {
}
/**
 * (experimental) The Public event accepts no options.
 *
 * @experimental
 */
export interface PublicOptions {
}
/**
 * (experimental) The Status event accepts no options.
 *
 * @experimental
 */
export interface StatusOptions {
}
