"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskWorkflow = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constants_1 = require("./constants");
const workflows_1 = require("./workflows");
const DEFAULT_JOB_ID = 'build';
/**
 * (experimental) A GitHub workflow for common build tasks within a project.
 *
 * @experimental
 */
class TaskWorkflow extends workflows_1.GithubWorkflow {
    /**
     * @experimental
     */
    constructor(github, options) {
        var _b, _c, _d, _e, _f, _g;
        super(github, options.name);
        this.jobId = (_b = options.jobId) !== null && _b !== void 0 ? _b : DEFAULT_JOB_ID;
        this.github = github;
        this.artifactsDirectory = options.artifactsDirectory;
        if (options.triggers) {
            if (options.triggers.issueComment) {
                // https://docs.github.com/en/actions/learn-github-actions/security-hardening-for-github-actions#potential-impact-of-a-compromised-runner
                throw new Error('Trigger "issueComment" should not be used due to a security concern');
            }
            this.on(options.triggers);
        }
        this.on({
            workflowDispatch: {},
        });
        const preCheckoutSteps = (_c = options.preCheckoutSteps) !== null && _c !== void 0 ? _c : [];
        const checkoutWith = options.checkoutWith ? { with: options.checkoutWith } : {};
        const preBuildSteps = (_d = options.preBuildSteps) !== null && _d !== void 0 ? _d : [];
        const postBuildSteps = (_e = options.postBuildSteps) !== null && _e !== void 0 ? _e : [];
        const gitIdentity = (_f = options.gitIdentity) !== null && _f !== void 0 ? _f : constants_1.DEFAULT_GITHUB_ACTIONS_USER;
        if (this.artifactsDirectory) {
            postBuildSteps.push({
                name: 'Upload artifact',
                uses: 'actions/upload-artifact@v2.1.1',
                // Setting to always will ensure that this step will run even if
                // the previous ones have failed (e.g. coverage report, internal logs, etc)
                if: 'always()',
                with: {
                    name: this.artifactsDirectory,
                    path: this.artifactsDirectory,
                },
            });
        }
        const job = {
            runsOn: (_g = options.runsOn) !== null && _g !== void 0 ? _g : ['ubuntu-latest'],
            container: options.container,
            env: options.env,
            permissions: options.permissions,
            if: options.condition,
            outputs: options.outputs,
            steps: [
                ...preCheckoutSteps,
                // check out sources.
                {
                    name: 'Checkout',
                    uses: 'actions/checkout@v2',
                    ...checkoutWith,
                },
                // sets git identity so we can push later
                constants_1.setGitIdentityStep(gitIdentity),
                ...preBuildSteps,
                // run the main build task
                {
                    name: options.task.name,
                    run: this.github.project.runTaskCommand(options.task),
                },
                ...postBuildSteps,
            ],
        };
        this.addJobs({ [this.jobId]: job });
    }
}
exports.TaskWorkflow = TaskWorkflow;
_a = JSII_RTTI_SYMBOL_1;
TaskWorkflow[_a] = { fqn: "projen.github.TaskWorkflow", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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