import { GitHub } from '.';
import { Component } from '../component';
/**
 * (experimental) Options for PullRequestLint.
 *
 * @experimental
 */
export interface PullRequestLintOptions {
    /**
     * (experimental) Validate that pull request titles follow Conventional Commits.
     *
     * @default true
     * @see https://www.conventionalcommits.org/
     * @experimental
     */
    readonly semanticTitle?: boolean;
    /**
     * (experimental) Options for validating the conventional commit title linter.
     *
     * @default - title must start with "feat", "fix", or "chore"
     * @experimental
     */
    readonly semanticTitleOptions?: SemanticTitleOptions;
    /**
     * (experimental) Github Runner selection labels.
     *
     * @default ["ubuntu-latest"]
     * @experimental
     */
    readonly runsOn?: string[];
}
/**
 * (experimental) Options for linting that PR titles follow Conventional Commits.
 *
 * @see https://www.conventionalcommits.org/
 * @experimental
 */
export interface SemanticTitleOptions {
    /**
     * (experimental) Configure a list of commit types that are allowed.
     *
     * @default ["feat", "fix", "chore"]
     * @experimental
     */
    readonly types?: string[];
    /**
     * (experimental) Configure that a scope must always be provided.
     *
     * e.g. feat(ui), fix(core)
     *
     * @default false
     * @experimental
     */
    readonly requireScope?: boolean;
}
/**
 * (experimental) Configure validations to run on GitHub pull requests.
 *
 * Only generates a file if at least one linter is configured.
 *
 * @experimental
 */
export declare class PullRequestLint extends Component {
    /**
     * @experimental
     */
    constructor(github: GitHub, options?: PullRequestLintOptions);
}
