"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const dependabot_1 = require("./dependabot");
const mergify_1 = require("./mergify");
const pr_template_1 = require("./pr-template");
const pull_request_lint_1 = require("./pull-request-lint");
const workflows_1 = require("./workflows");
/**
 * @experimental
 */
class GitHub extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b, _c, _d;
        super(project);
        this.workflowsEnabled = (_b = options.workflows) !== null && _b !== void 0 ? _b : true;
        if ((_c = options.mergify) !== null && _c !== void 0 ? _c : true) {
            this.mergify = new mergify_1.Mergify(this, options.mergifyOptions);
        }
        if ((_d = options.pullRequestLint) !== null && _d !== void 0 ? _d : true) {
            new pull_request_lint_1.PullRequestLint(this, options.pullRequestLintOptions);
        }
    }
    /**
     * (experimental) Returns the `GitHub` component of a project or `undefined` if the project does not have a GitHub component.
     *
     * @experimental
     */
    static of(project) {
        const isGitHub = (c) => c instanceof GitHub;
        return project.components.find(isGitHub);
    }
    /**
     * (experimental) All workflows.
     *
     * @experimental
     */
    get workflows() {
        const isWorkflow = (c) => c instanceof workflows_1.GithubWorkflow;
        return this.project.components.filter(isWorkflow).sort((w1, w2) => w1.name.localeCompare(w2.name));
    }
    /**
     * (experimental) Adds a workflow to the project.
     *
     * @param name Name of the workflow.
     * @returns a GithubWorkflow instance
     * @experimental
     */
    addWorkflow(name) {
        const workflow = new workflows_1.GithubWorkflow(this, name);
        return workflow;
    }
    /**
     * @experimental
     */
    addPullRequestTemplate(...content) {
        return new pr_template_1.PullRequestTemplate(this, { lines: content });
    }
    /**
     * @experimental
     */
    addDependabot(options) {
        return new dependabot_1.Dependabot(this, options);
    }
    /**
     * (experimental) Finds a GitHub workflow by name.
     *
     * Returns `undefined` if the workflow cannot be found.
     *
     * @param name The name of the GitHub workflow.
     * @experimental
     */
    tryFindWorkflow(name) {
        return this.workflows.find(w => w.name === name);
    }
}
exports.GitHub = GitHub;
_a = JSII_RTTI_SYMBOL_1;
GitHub[_a] = { fqn: "projen.github.GitHub", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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