"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHubProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _1 = require(".");
const clobber_1 = require("../clobber");
const gitpod_1 = require("../gitpod");
const project_1 = require("../project");
const readme_1 = require("../readme");
const vscode_1 = require("../vscode");
/**
 * (deprecated) GitHub-based project.
 *
 * @deprecated This is a *temporary* class. At the moment, our base project
 * types such as `NodeProject` and `JavaProject` are derived from this, but we
 * want to be able to use these project types outside of GitHub as well. One of
 * the next steps to address this is to abstract workflows so that different
 * "engines" can be used to implement our CI/CD solutions.
 */
class GitHubProject extends project_1.Project {
    /**
     * @deprecated
     */
    constructor(options) {
        var _b, _c, _d, _e, _f;
        super(options);
        this.projectType = (_b = options.projectType) !== null && _b !== void 0 ? _b : project_1.ProjectType.UNKNOWN;
        // we only allow these global services to be used in root projects
        const github = (_c = options.github) !== null && _c !== void 0 ? _c : (this.parent ? false : true);
        this.github = github ? new _1.GitHub(this, {
            mergify: options.mergify,
            mergifyOptions: options.mergifyOptions,
            ...options.githubOptions,
        }) : undefined;
        const vscode = (_d = options.vscode) !== null && _d !== void 0 ? _d : (this.parent ? false : true);
        this.vscode = vscode ? new vscode_1.VsCode(this) : undefined;
        this.gitpod = options.gitpod ? new gitpod_1.Gitpod(this) : undefined;
        this.devContainer = options.devContainer ? new vscode_1.DevContainer(this) : undefined;
        if ((_e = options.clobber) !== null && _e !== void 0 ? _e : true) {
            new clobber_1.Clobber(this);
        }
        new readme_1.SampleReadme(this, options.readme);
        if (options.autoApproveOptions && this.github) {
            this.autoApprove = new _1.AutoApprove(this.github, options.autoApproveOptions);
        }
        const stale = (_f = options.stale) !== null && _f !== void 0 ? _f : true;
        if (stale && this.github) {
            new _1.Stale(this.github, options.staleOptions);
        }
    }
    /**
     * (deprecated) Marks the provided file(s) as being generated.
     *
     * This is achieved using the
     * github-linguist attributes. Generated files do not count against the
     * repository statistics and language breakdown.
     *
     * @param glob the glob pattern to match (could be a file path).
     * @see https://github.com/github/linguist/blob/master/docs/overrides.md
     * @deprecated
     */
    annotateGenerated(glob) {
        this.gitattributes.addAttributes(glob, 'linguist-generated');
    }
}
exports.GitHubProject = GitHubProject;
_a = JSII_RTTI_SYMBOL_1;
GitHubProject[_a] = { fqn: "projen.github.GitHubProject", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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