"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setGitIdentityStep = exports.DEFAULT_GITHUB_ACTIONS_USER = void 0;
/**
 * Represents the github-actions user.
 *
 * Use this when you need to perform a commit as part of your workflow.
 */
exports.DEFAULT_GITHUB_ACTIONS_USER = {
    name: 'github-actions',
    email: 'github-actions@github.com',
};
/**
 * Workflow flow to configure git with the github actions identity.
 */
function setGitIdentityStep(id) {
    return {
        name: 'Set git identity',
        run: [
            'git config --global init.defaultBranch main',
            `git config user.name "${id.name}"`,
            `git config user.email "${id.email}"`,
        ].join('\n'),
    };
}
exports.setGitIdentityStep = setGitIdentityStep;
;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uc3RhbnRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2dpdGh1Yi9jb25zdGFudHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBR0E7Ozs7R0FJRztBQUNVLFFBQUEsMkJBQTJCLEdBQWdCO0lBQ3RELElBQUksRUFBRSxnQkFBZ0I7SUFDdEIsS0FBSyxFQUFFLDJCQUEyQjtDQUNuQyxDQUFDO0FBRUY7O0dBRUc7QUFDSCxTQUFnQixrQkFBa0IsQ0FBQyxFQUFlO0lBQ2hELE9BQU87UUFDTCxJQUFJLEVBQUUsa0JBQWtCO1FBQ3hCLEdBQUcsRUFBRTtZQUNILDZDQUE2QztZQUM3Qyx5QkFBeUIsRUFBRSxDQUFDLElBQUksR0FBRztZQUNuQywwQkFBMEIsRUFBRSxDQUFDLEtBQUssR0FBRztTQUN0QyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7S0FDYixDQUFDO0FBQ0osQ0FBQztBQVRELGdEQVNDO0FBQUEsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEdpdElkZW50aXR5IH0gZnJvbSAnLic7XG5pbXBvcnQgKiBhcyB3b3JrZmxvdyBmcm9tICcuL3dvcmtmbG93cy1tb2RlbCc7XG5cbi8qKlxuICogUmVwcmVzZW50cyB0aGUgZ2l0aHViLWFjdGlvbnMgdXNlci5cbiAqXG4gKiBVc2UgdGhpcyB3aGVuIHlvdSBuZWVkIHRvIHBlcmZvcm0gYSBjb21taXQgYXMgcGFydCBvZiB5b3VyIHdvcmtmbG93LlxuICovXG5leHBvcnQgY29uc3QgREVGQVVMVF9HSVRIVUJfQUNUSU9OU19VU0VSOiBHaXRJZGVudGl0eSA9IHtcbiAgbmFtZTogJ2dpdGh1Yi1hY3Rpb25zJyxcbiAgZW1haWw6ICdnaXRodWItYWN0aW9uc0BnaXRodWIuY29tJyxcbn07XG5cbi8qKlxuICogV29ya2Zsb3cgZmxvdyB0byBjb25maWd1cmUgZ2l0IHdpdGggdGhlIGdpdGh1YiBhY3Rpb25zIGlkZW50aXR5LlxuICovXG5leHBvcnQgZnVuY3Rpb24gc2V0R2l0SWRlbnRpdHlTdGVwKGlkOiBHaXRJZGVudGl0eSk6IHdvcmtmbG93LkpvYlN0ZXAge1xuICByZXR1cm4ge1xuICAgIG5hbWU6ICdTZXQgZ2l0IGlkZW50aXR5JyxcbiAgICBydW46IFtcbiAgICAgICdnaXQgY29uZmlnIC0tZ2xvYmFsIGluaXQuZGVmYXVsdEJyYW5jaCBtYWluJyxcbiAgICAgIGBnaXQgY29uZmlnIHVzZXIubmFtZSBcIiR7aWQubmFtZX1cImAsXG4gICAgICBgZ2l0IGNvbmZpZyB1c2VyLmVtYWlsIFwiJHtpZC5lbWFpbH1cImAsXG4gICAgXS5qb2luKCdcXG4nKSxcbiAgfTtcbn07XG4iXX0=