"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoMerge = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
/**
 * (experimental) Sets up mergify to merging approved pull requests.
 *
 * If `buildJob` is specified, the specified GitHub workflow job ID is required
 * to succeed in order for the PR to be merged.
 *
 * `approvedReviews` specified the number of code review approvals required for
 * the PR to be merged.
 *
 * @experimental
 */
class AutoMerge extends component_1.Component {
    /**
     * @experimental
     */
    constructor(github, options) {
        var _b, _c;
        super(github.project);
        const mergify = github.mergify;
        if (!mergify) {
            throw new Error('auto merging requires mergify to be enabled');
        }
        const successfulBuild = options.buildJob
            ? [`status-success=${options.buildJob}`]
            : [];
        const blockingLabels = (_b = options.blockingLabels) !== null && _b !== void 0 ? _b : ['do-not-merge'];
        const blockingCondition = (blockingLabels === null || blockingLabels === void 0 ? void 0 : blockingLabels.length) ? [`-label~=(${blockingLabels.join('|')})`]
            : [];
        const mergeAction = {
            merge: {
                // squash all commits into a single commit when merging
                method: 'squash',
                // use PR title+body as the commit message
                commit_message_template: [
                    '{{ title }} (#{{ number }})',
                    '',
                    '{{ body }}',
                ].join('\n'),
                // update PR branch so it's up-to-date before merging
                strict: 'smart',
                strict_method: 'merge',
            },
            delete_head_branch: {},
        };
        const approvedReviews = (_c = options.approvedReviews) !== null && _c !== void 0 ? _c : 1;
        mergify.addRule({
            name: 'Automatic merge on approval and successful build',
            actions: mergeAction,
            conditions: [
                `#approved-reviews-by>=${approvedReviews}`,
                ...blockingCondition,
                ...successfulBuild,
            ],
        });
        this.project.addPackageIgnore('/.mergify.yml');
    }
}
exports.AutoMerge = AutoMerge;
_a = JSII_RTTI_SYMBOL_1;
AutoMerge[_a] = { fqn: "projen.github.AutoMerge", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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