"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tryProcessMacro = void 0;
const path = require("path");
const util_1 = require("../util");
function tryProcessMacro(cwd, macro) {
    var _a, _b;
    if (!macro.startsWith('$')) {
        return undefined;
    }
    const basedir = path.basename(cwd);
    switch (macro) {
        case '$BASEDIR': return basedir;
        case '$GIT_REMOTE':
            const origin = util_1.execOrUndefined('git remote get-url origin', { cwd });
            if (origin) {
                return origin;
            }
            const slug = (_a = getFromGitConfig(cwd, 'github.user')) !== null && _a !== void 0 ? _a : resolveEmail(cwd).split('@')[0];
            return `https://github.com/${slug}/${basedir}.git`;
        case '$GIT_USER_NAME': return (_b = getFromGitConfig(cwd, 'user.name')) !== null && _b !== void 0 ? _b : 'user';
        case '$GIT_USER_EMAIL': return resolveEmail(cwd);
        case '$PYTHON_MODULE_NAME': return util_1.formatAsPythonModule(basedir);
    }
    return undefined;
}
exports.tryProcessMacro = tryProcessMacro;
/**
 * Returns a value from git config. Searches local and then global git config.
 * @param key the config key
 */
function getFromGitConfig(cwd, key) {
    var _a;
    return (_a = util_1.execOrUndefined(`git config --get --includes ${key}`, { cwd })) !== null && _a !== void 0 ? _a : util_1.execOrUndefined(`git config --get --global --includes ${key}`, { cwd });
}
function resolveEmail(cwd) {
    var _a;
    return (_a = getFromGitConfig(cwd, 'user.email')) !== null && _a !== void 0 ? _a : 'user@domain.com';
}
//# sourceMappingURL=data:application/json;base64,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