"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cleanup = exports.FILE_MANIFEST = void 0;
const path = require("path");
const fs = require("fs-extra");
const fs_extra_1 = require("fs-extra");
const glob = require("glob");
const common_1 = require("./common");
const logging = require("./logging");
exports.FILE_MANIFEST = `${common_1.PROJEN_DIR}/files.json`;
function cleanup(dir, exclude) {
    try {
        for (const f of findGeneratedFiles(dir, exclude)) {
            fs.removeSync(f);
        }
    }
    catch (e) {
        logging.warn(`warning: failed to clean up generated files: ${e.stack}`);
    }
}
exports.cleanup = cleanup;
function findGeneratedFiles(dir, exclude) {
    let files = getFilesFromManifest(dir);
    if (files.length > 0) {
        return files;
    }
    const ignore = [...readGitIgnore(dir), 'node_modules/**', ...exclude, '.git/**'];
    files = glob.sync('**', {
        ignore,
        cwd: dir,
        dot: true,
        nodir: true,
        absolute: true,
    });
    const generated = new Array();
    for (const file of files) {
        const contents = fs.readFileSync(file, 'utf-8');
        if (contents.includes(common_1.PROJEN_MARKER)) {
            generated.push(file);
        }
    }
    return generated;
}
function getFilesFromManifest(dir) {
    try {
        const fileManifestPath = path.resolve(dir, exports.FILE_MANIFEST);
        if (fs_extra_1.existsSync(fileManifestPath)) {
            const fileManifest = JSON.parse(fs_extra_1.readFileSync(fileManifestPath, 'utf-8'));
            if (fileManifest.files) {
                return fileManifest.files.map((f) => path.resolve(dir, f));
            }
        }
    }
    catch (e) {
        logging.warn(`warning: unable to get files to clean from file manifest: ${e.stack}`);
    }
    return [];
}
function readGitIgnore(dir) {
    const filepath = path.join(dir, '.gitignore');
    if (!fs.pathExistsSync(filepath)) {
        return [];
    }
    return fs.readFileSync(filepath, 'utf-8')
        .split('\n')
        .filter(x => (x === null || x === void 0 ? void 0 : x.trim()) !== '')
        .filter(x => !x.startsWith('#') && !x.startsWith('!'))
        .map(x => x.replace(/^\//, '')) // remove "/" prefix
        .map(x => `${x}\n${x}/**`)
        .join('\n')
        .split('\n');
}
//# sourceMappingURL=data:application/json;base64,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