"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsiiProject = exports.Stability = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const typescript_1 = require("../typescript");
const consts_1 = require("./consts");
const jsii_docgen_1 = require("./jsii-docgen");
const EMAIL_REGEX = /(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|"(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])/;
const URL_REGEX = /((([A-Za-z]{3,9}:(?:\/\/)?)(?:[\-;:&=\+\$,\w]+@)?[A-Za-z0-9\.\-]+|(?:www\.|[\-;:&=\+\$,\w]+@)[A-Za-z0-9\.\-]+)((?:\/[\+~%\/\.\w\-_]*)?\??(?:[\-\+=&;%@\.\w_]*)#?(?:[\.\!\/\\\w]*))?)/;
/**
 * @experimental
 */
var Stability;
(function (Stability) {
    Stability["EXPERIMENTAL"] = "experimental";
    Stability["STABLE"] = "stable";
    Stability["DEPRECATED"] = "deprecated";
})(Stability = exports.Stability || (exports.Stability = {}));
/**
 * (experimental) Multi-language jsii library project.
 *
 * @experimental
 * @pjid jsii
 */
class JsiiProject extends typescript_1.TypeScriptProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o;
        const { authorEmail, authorUrl } = parseAuthorAddress(options);
        super({
            repository: options.repositoryUrl,
            authorName: options.author,
            authorEmail,
            authorUrl,
            ...options,
            releaseToNpm: false,
            disableTsconfig: true,
            docgen: false,
        });
        const srcdir = this.srcdir;
        const libdir = this.libdir;
        this.addFields({ types: `${libdir}/index.d.ts` });
        // this is an unhelpful warning
        const jsiiFlags = [
            '--silence-warnings=reserved-word',
            '--no-fix-peer-dependencies',
        ].join(' ');
        const compatIgnore = (_b = options.compatIgnore) !== null && _b !== void 0 ? _b : '.compatignore';
        this.addFields({ stability: (_c = options.stability) !== null && _c !== void 0 ? _c : Stability.STABLE });
        if (options.stability === Stability.DEPRECATED) {
            this.addFields({ deprecated: true });
        }
        const compatTask = this.addTask('compat', {
            description: 'Perform API compatibility check against latest version',
            exec: `jsii-diff npm:$(node -p "require(\'./package.json\').name") -k --ignore-file ${compatIgnore} || (echo "\nUNEXPECTED BREAKING CHANGES: add keys such as \'removed:constructs.Node.of\' to ${compatIgnore} to skip.\n" && exit 1)`,
        });
        const compat = (_d = options.compat) !== null && _d !== void 0 ? _d : false;
        if (compat) {
            this.compileTask.spawn(compatTask);
        }
        this.compileTask.reset(`jsii ${jsiiFlags}`);
        this.watchTask.reset(`jsii -w ${jsiiFlags}`);
        this.packageAllTask = this.addTask('package-all', {
            description: 'Packages artifacts for all target languages',
        });
        const targets = {};
        const jsii = {
            outdir: this.artifactsDirectory,
            targets,
            tsc: {
                outDir: libdir,
                rootDir: srcdir,
            },
        };
        if (options.excludeTypescript) {
            jsii.excludeTypescript = options.excludeTypescript;
        }
        this.addFields({ jsii });
        if (options.releaseToNpm != false) {
            (_e = this.release) === null || _e === void 0 ? void 0 : _e.publisher.publishToNpm({
                ...this.pacmakForLanguage('js'),
                registry: this.package.npmRegistry,
                npmTokenSecret: this.package.npmTokenSecret,
            });
            this.addPackagingTarget('js');
        }
        // we cannot call an option `java` because the java code generated by jsii
        // does not compile due to a conflict between this option name and the `java`
        // package (e.g. when `java.util.Objects` is referenced).
        if ('java' in options) {
            throw new Error('the "java" option is now called "publishToMaven"');
        }
        if (options.publishToMaven) {
            targets.java = {
                package: options.publishToMaven.javaPackage,
                maven: {
                    groupId: options.publishToMaven.mavenGroupId,
                    artifactId: options.publishToMaven.mavenArtifactId,
                },
            };
            (_f = this.release) === null || _f === void 0 ? void 0 : _f.publisher.publishToMaven({
                ...this.pacmakForLanguage('java'),
                ...options.publishToMaven,
            });
            this.addPackagingTarget('java');
        }
        const pypi = (_g = options.publishToPypi) !== null && _g !== void 0 ? _g : options.python;
        if (pypi) {
            targets.python = {
                distName: pypi.distName,
                module: pypi.module,
            };
            (_h = this.release) === null || _h === void 0 ? void 0 : _h.publisher.publishToPyPi({
                ...this.pacmakForLanguage('python'),
                ...pypi,
            });
            this.addPackagingTarget('python');
        }
        const nuget = (_j = options.publishToNuget) !== null && _j !== void 0 ? _j : options.dotnet;
        if (nuget) {
            targets.dotnet = {
                namespace: nuget.dotNetNamespace,
                packageId: nuget.packageId,
            };
            (_k = this.release) === null || _k === void 0 ? void 0 : _k.publisher.publishToNuget({
                ...this.pacmakForLanguage('dotnet'),
                ...nuget,
            });
            this.addPackagingTarget('dotnet');
        }
        const golang = options.publishToGo;
        if (golang) {
            targets.go = {
                moduleName: golang.moduleName,
            };
            (_l = this.release) === null || _l === void 0 ? void 0 : _l.publisher.publishToGo({
                ...this.pacmakForLanguage('go'),
                ...golang,
            });
            this.addPackagingTarget('go');
        }
        this.addDevDeps('jsii', 'jsii-diff');
        this.gitignore.exclude('.jsii', 'tsconfig.json');
        (_m = this.npmignore) === null || _m === void 0 ? void 0 : _m.include('.jsii');
        if ((_o = options.docgen) !== null && _o !== void 0 ? _o : true) {
            new jsii_docgen_1.JsiiDocgen(this);
        }
        // jsii updates .npmignore, so we make it writable
        if (this.npmignore) {
            this.npmignore.readonly = false;
        }
        // run `jsii-pacmak` at the end of the upgrade workflow because at the moment
        // we don't have an ability to leverage the multiple build jobs in the upgrade workflow
        // and we want to preserve the behavior of the old upgrade workflow.
        if (this.upgradeWorkflow) {
            this.upgradeWorkflow.containerOptions = { image: this.superchainImage };
            this.upgradeWorkflow.addPostBuildSteps({
                name: 'Verify language bindings',
                run: this.runTaskCommand(this.packageAllTask),
            });
        }
    }
    /**
     * Returns the jsii/superchain image that is compatible with the minimum node
     * version of this project.
     */
    get superchainImage() {
        return consts_1.determineSuperchainImage(this.minNodeVersion);
    }
    /**
     * Adds a target language to the build workflow and creates a package task.
     * @param language
     * @returns
     */
    addPackagingTarget(language) {
        var _b;
        if (!this.buildWorkflow) {
            return;
        }
        const pacmak = this.pacmakForLanguage(language);
        this.buildWorkflow.addPostBuildJob(`package-${language}`, {
            runsOn: ['ubuntu-latest'],
            permissions: {},
            tools: {
                node: { version: '14.x' },
                ...pacmak.publishTools,
            },
            steps: (_b = pacmak.prePublishSteps) !== null && _b !== void 0 ? _b : [],
        });
        const packageTask = this.tasks.addTask(`package:${language}`, {
            description: `Create ${language} language bindings`,
        });
        for (const cmd of pacmak.commands) {
            packageTask.exec(cmd);
        }
        this.packageAllTask.spawn(packageTask);
    }
    pacmakForLanguage(target) {
        const commands = [
            'jsii_version=$(node -p "JSON.parse(fs.readFileSync(\'.jsii\')).jsiiVersion.split(\' \')[0]")',
            `npx jsii-pacmak@$jsii_version -v --outdir $PWD/${this.artifactsDirectory} --target ${target}`,
        ];
        return {
            commands: commands,
            publishTools: consts_1.JSII_TOOLCHAIN[target],
            prePublishSteps: [
                {
                    name: 'Extract npm tarball',
                    run: [
                        `tar -xzf ${this.artifactsJavascriptDirectory}/*.tgz --strip-components=1`,
                        `rm -fr ${this.artifactsJavascriptDirectory}`,
                    ].join('\n'),
                },
                {
                    name: `Create ${target} artifact`,
                    run: commands.join('\n'),
                },
            ],
        };
    }
}
exports.JsiiProject = JsiiProject;
_a = JSII_RTTI_SYMBOL_1;
JsiiProject[_a] = { fqn: "projen.cdk.JsiiProject", version: "0.46.3" };
function parseAuthorAddress(options) {
    let authorEmail = options.authorEmail;
    let authorUrl = options.authorUrl;
    if (options.authorAddress) {
        if (options.authorEmail && options.authorEmail !== options.authorAddress) {
            throw new Error('authorEmail is deprecated and cannot be used in conjunction with authorAddress');
        }
        if (options.authorUrl && options.authorUrl !== options.authorAddress) {
            throw new Error('authorUrl is deprecated and cannot be used in conjunction with authorAddress.');
        }
        if (EMAIL_REGEX.test(options.authorAddress)) {
            authorEmail = options.authorAddress;
        }
        else if (URL_REGEX.test(options.authorAddress)) {
            authorUrl = options.authorAddress;
        }
        else {
            throw new Error(`authorAddress must be either an email address or a URL: ${options.authorAddress}`);
        }
    }
    return { authorEmail, authorUrl };
}
//# sourceMappingURL=data:application/json;base64,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