"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.determineSuperchainImage = exports.JSII_TOOLCHAIN = void 0;
const semver = require("semver");
/**
 * GitHub workflow job steps for setting up the tools required for various JSII targets.
 */
exports.JSII_TOOLCHAIN = {
    js: {},
    java: { java: { version: '11.x' } },
    python: { python: { version: '3.x' } },
    go: { go: { version: '^1.16.0' } },
    dotnet: { dotnet: { version: '3.x' } },
};
const SUPERCHAIN_IMAGE = 'jsii/superchain:1-buster-slim';
const SUPERCHAIN_NODE_VERSIONS = [12, 14, 16]; // supported jsii/superchain image tags: `1-buster-slim-nodeNN`
/**
 * Determines the jsii/superchain image to use based on the minimum node
 * version.
 *
 * @param minNodeVersion The minimum node version of the project. If not
 * specified, v14.17.4 is used.
 */
function determineSuperchainImage(minNodeVersion) {
    // the default image (`jsii/superchain:1-buster-slim`) will include the
    // minimum supported node version of JSII (as of this writing it is 12.x).
    if (!minNodeVersion) {
        return SUPERCHAIN_IMAGE;
    }
    const major = semver.major(minNodeVersion);
    if (!SUPERCHAIN_NODE_VERSIONS.includes(major)) {
        throw new Error(`No jsii/superchain image available for node ${major}.x. Supported node versions: ${SUPERCHAIN_NODE_VERSIONS.map(m => `${m}.x`).join(',')}`);
    }
    return `${SUPERCHAIN_IMAGE}-node${major}`;
}
exports.determineSuperchainImage = determineSuperchainImage;
//# sourceMappingURL=data:application/json;base64,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