import { Tools } from '../github/workflows-model';
export declare type JsiiPacmakTarget = 'js' | 'go' | 'java' | 'python' | 'dotnet';
/**
 * GitHub workflow job steps for setting up the tools required for various JSII targets.
 */
export declare const JSII_TOOLCHAIN: Record<JsiiPacmakTarget, Tools>;
/**
 * Determines the jsii/superchain image to use based on the minimum node
 * version.
 *
 * @param minNodeVersion The minimum node version of the project. If not
 * specified, v14.17.4 is used.
 */
export declare function determineSuperchainImage(minNodeVersion?: string): string;
