import { Task } from '..';
import { Component } from '../component';
import { GitIdentity } from '../github';
import { Job, JobStep } from '../github/workflows-model';
import { Project } from '../project';
/**
 * @experimental
 */
export interface BuildWorkflowOptions {
    /**
     * (experimental) The task to execute in order to build the project.
     *
     * @experimental
     */
    readonly buildTask: Task;
    /**
     * (experimental) A name of a directory that includes build artifacts.
     *
     * @experimental
     */
    readonly artifactsDirectory: string;
    /**
     * (experimental) The container image to use for builds.
     *
     * @default - the default workflow container
     * @experimental
     */
    readonly containerImage?: string;
    /**
     * (experimental) Automatically update files modified during builds to pull-request branches.
     *
     * This means
     * that any files synthesized by projen or e.g. test snapshots will always be up-to-date
     * before a PR is merged.
     *
     * Implies that PR builds do not have anti-tamper checks.
     *
     * @default true
     * @experimental
     */
    readonly mutableBuild?: boolean;
    /**
     * (experimental) Steps to execute before the build.
     *
     * @default []
     * @experimental
     */
    readonly preBuildSteps?: JobStep[];
    /**
     * (experimental) Steps to execute after build.
     *
     * @default []
     * @experimental
     */
    readonly postBuildSteps?: JobStep[];
    /**
     * (experimental) Git identity to use for the workflow.
     *
     * @default - default identity
     * @experimental
     */
    readonly gitIdentity?: GitIdentity;
    /**
     * (experimental) Build environment variables.
     *
     * @default {}
     * @experimental
     */
    readonly env?: {
        [key: string]: string;
    };
    /**
     * (experimental) Enable anti-tamper check.
     *
     * @default true
     * @experimental
     */
    readonly antitamper?: boolean;
}
/**
 * @experimental
 */
export declare class BuildWorkflow extends Component {
    private readonly postBuildSteps;
    private readonly preBuildSteps;
    private readonly antitamperSteps;
    private readonly mutableBuilds;
    private readonly gitIdentity;
    private readonly buildTask;
    private readonly github;
    private readonly workflow;
    private readonly primaryJobId;
    private readonly artifactsDirectory?;
    private readonly _buildJobIds;
    private uploadArtitactSteps?;
    /**
     * @experimental
     */
    constructor(project: Project, options: BuildWorkflowOptions);
    /**
     * (experimental) Returns a list of job IDs that are part of the build.
     *
     * @experimental
     */
    get buildJobIds(): string[];
    /**
     * (experimental) Adds steps that are executed after the build.
     *
     * @param steps The job steps.
     * @experimental
     */
    addPostBuildSteps(...steps: JobStep[]): void;
    /**
     * (experimental) Adds another job to the build workflow which is executed after the build job succeeded.
     *
     * @param id The id of the new job.
     * @param job The job specification.
     * @experimental
     */
    addPostBuildJob(id: string, job: Job): void;
    /**
     * Called (lazily) during synth to render the build job steps.
     */
    private renderSteps;
}
