import { Component } from '../component';
import { BundlingOptions } from '../javascript';
import { Project } from '../project';
import { AwsCdkDeps } from './awscdk-deps';
/**
 * (experimental) Common options for `LambdaFunction`.
 *
 * Applies to all functions in
 * auto-discovery.
 *
 * @experimental
 */
export interface LambdaFunctionCommonOptions {
    /**
     * (experimental) The node.js version to target.
     *
     * @default Runtime.NODEJS_14_X
     * @experimental
     */
    readonly runtime?: LambdaRuntime;
    /**
     * (experimental) Bundling options for this AWS Lambda function.
     *
     * If not specified the default bundling options specified for the project
     * `Bundler` instance will be used.
     *
     * @default - defaults
     * @experimental
     */
    readonly bundlingOptions?: BundlingOptions;
}
/**
 * (experimental) Options for `Function`.
 *
 * @experimental
 */
export interface LambdaFunctionOptions extends LambdaFunctionCommonOptions {
    /**
     * (experimental) A path from the project root directory to a TypeScript file which contains the AWS Lambda handler entrypoint (exports a `handler` function).
     *
     * This is relative to the root directory of the project.
     *
     * @experimental
     * @example
     *
     * "src/subdir/foo.lambda.ts"
     */
    readonly entrypoint: string;
    /**
     * (experimental) The name of the generated TypeScript source file.
     *
     * This file should also be
     * under the source tree.
     *
     * @default - The name of the entrypoint file, with the `-function.ts` suffix
     * instead of `.lambda.ts`.
     * @experimental
     */
    readonly constructFile?: string;
    /**
     * (experimental) The name of the generated `lambda.Function` subclass.
     *
     * @default - A pascal cased version of the name of the entrypoint file, with
     * the extension `Function` (e.g. `ResizeImageFunction`).
     * @experimental
     */
    readonly constructName?: string;
    /**
     * (experimental) AWS CDK dependency manager.
     *
     * @experimental
     */
    readonly cdkDeps: AwsCdkDeps;
}
/**
 * (experimental) Generates a pre-bundled AWS Lambda function construct from handler code.
 *
 * To use this, create an AWS Lambda handler file under your source tree with
 * the `.lambda.ts` extension and add a `LambdaFunction` component to your
 * typescript project pointing to this entrypoint.
 *
 * This will add a task to your "compile" step which will use `esbuild` to
 * bundle the handler code into the build directory. It will also generate a
 * file `src/foo-function.ts` with a custom AWS construct called `FooFunction`
 * which extends `@aws-cdk/aws-lambda.Function` which is bound to the bundled
 * handle through an asset.
 *
 * @experimental
 * @example
 *
 * new LambdaFunction(myProject, {
 *   srcdir: myProject.srcdir,
 *   entrypoint: 'src/foo.lambda.ts',
 * });
 */
export declare class LambdaFunction extends Component {
    /**
     * (experimental) Defines a pre-bundled AWS Lambda function construct from handler code.
     *
     * @param project The project to use.
     * @param options Options.
     * @experimental
     */
    constructor(project: Project, options: LambdaFunctionOptions);
}
/**
 * (experimental) The runtime for the AWS Lambda function.
 *
 * @experimental
 */
export declare class LambdaRuntime {
    /**
     * The aws-lambda.Runtime member name to use.
     */
    readonly functionRuntime: string;
    /**
     * The esbuild setting to use.
     */
    readonly esbuildTarget: string;
    /**
     * (experimental) Node.js 10.x.
     *
     * @experimental
     */
    static readonly NODEJS_10_X: LambdaRuntime;
    /**
     * (experimental) Node.js 12.x.
     *
     * @experimental
     */
    static readonly NODEJS_12_X: LambdaRuntime;
    /**
     * (experimental) Node.js 14.x.
     *
     * @experimental
     */
    static readonly NODEJS_14_X: LambdaRuntime;
    /**
     * @experimental
     */
    readonly esbuildPlatform = "node";
    private constructor();
}
