"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
const internal_1 = require("./internal");
/**
 * (experimental) Cloud integration tests.
 *
 * @experimental
 */
class IntegrationTest extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b;
        super(project);
        const entry = options.entrypoint;
        const name = path_1.basename(entry, internal_1.TYPESCRIPT_INTEG_EXT);
        const dir = path_1.dirname(entry);
        const deploydir = path_1.join(dir, '.tmp', `${name}.integ`, 'deploy.cdk.out');
        const actualdir = path_1.join(dir, '.tmp', `${name}.integ`, 'synth.cdk.out');
        const snapshotdir = path_1.join(dir, `${name}.integ.snapshot`);
        const app = `ts-node -P ${options.tsconfigPath} ${entry}`;
        if (!project.deps.tryGetDependency('ts-node')) {
            project.deps.addDependency('ts-node', dependencies_1.DependencyType.BUILD);
        }
        const opts = [
            `--app "${app}"`,
            '--no-version-reporting',
            // don't inject cloudformation metadata into template
            '--no-path-metadata',
            '--no-asset-metadata',
        ];
        if (options.cdkDeps.cdkMajorVersion === 1) {
            // add all feature flags
            const features = [
                ...internal_1.FEATURE_FLAGS,
                '@aws-cdk/core:newStyleStackSynthesis',
            ];
            for (const feature of features) {
                opts.push(`--context ${feature}=true`);
            }
        }
        const cdkopts = opts.join(' ');
        const deployTask = project.addTask(`integ:${name}:deploy`, {
            description: `deploy integration test '${name}' and capture snapshot`,
        });
        deployTask.exec(`rm -fr ${deploydir}`);
        deployTask.exec(`cdk deploy ${cdkopts} --require-approval=never -o ${deploydir}`);
        // if deployment was successful, copy the deploy dir to the expected dir
        deployTask.exec(`rm -fr ${snapshotdir}`);
        deployTask.exec(`mv ${deploydir} ${snapshotdir}`);
        const watchTask = project.addTask(`integ:${name}:watch`, {
            description: `watch integration test '${name}' (without updating snapshots)`,
            exec: `cdk watch ${cdkopts} -o ${deploydir}`,
        });
        const destroyTask = project.addTask(`integ:${name}:destroy`, {
            description: `destroy integration test '${name}'`,
            exec: `cdk destroy --app ${snapshotdir} --no-version-reporting`,
        });
        const destroyAfterDeploy = (_b = options.destroyAfterDeploy) !== null && _b !== void 0 ? _b : true;
        if (destroyAfterDeploy) {
            deployTask.spawn(destroyTask);
        }
        const exclude = ['asset.*', 'cdk.out', 'manifest.json', 'tree.json'];
        const assertTask = project.addTask(`integ:${name}:assert`, {
            description: `assert the snapshot of integration test '${name}'`,
        });
        assertTask.exec(`[ -d "${snapshotdir}" ] || (echo "No snapshot available for integration test '${name}'. Run 'projen ${deployTask.name}' to capture." && exit 1)`);
        assertTask.exec(`cdk synth ${cdkopts} -o ${actualdir} > /dev/null`);
        assertTask.exec(`diff -r ${exclude.map(x => `-x ${x}`).join(' ')} ${snapshotdir}/ ${actualdir}/`);
        const snapshotTask = project.addTask(`integ:${name}:snapshot`, {
            description: `update snapshot for integration test "${name}"`,
            exec: `cdk synth ${cdkopts} -o ${snapshotdir} > /dev/null`,
        });
        // synth as part of our tests, which means that if outdir changes, anti-tamper will fail
        project.testTask.spawn(assertTask);
        project.addGitIgnore(`!${snapshotdir}`); // commit outdir to git but not assets
        // do not commit all files we are excluding
        for (const x of exclude) {
            project.addGitIgnore(`${snapshotdir}/${x}`);
            project.addGitIgnore(`${snapshotdir}/**/${x}`); // nested assemblies
        }
        project.addGitIgnore(deploydir);
        project.addPackageIgnore(deploydir);
        project.addGitIgnore(actualdir);
        project.addPackageIgnore(actualdir);
        // commit the snapshot (but not into the tarball)
        project.addGitIgnore(`!${snapshotdir}`);
        project.addPackageIgnore(snapshotdir);
        this.deployTask = deployTask;
        this.assertTask = assertTask;
        this.destroyTask = destroyTask;
        this.snapshotTask = snapshotTask;
        this.watchTask = watchTask;
    }
}
exports.IntegrationTest = IntegrationTest;
_a = JSII_RTTI_SYMBOL_1;
IntegrationTest[_a] = { fqn: "projen.awscdk.IntegrationTest", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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