import { Component } from '../component';
import { Project } from '../project';
import { Task } from '../task';
import { AwsCdkDeps } from './awscdk-deps';
/**
 * @experimental
 */
export interface IntegrationTestCommonOptions {
    /**
     * (experimental) Destroy the test app after a successful deployment.
     *
     * If disabled, leaves the
     * app deployed in the dev account.
     *
     * @default true
     * @experimental
     */
    readonly destroyAfterDeploy?: boolean;
}
/**
 * (experimental) Options for `IntegrationTest`.
 *
 * @experimental
 */
export interface IntegrationTestOptions extends IntegrationTestCommonOptions {
    /**
     * (experimental) A path from the project root directory to a TypeScript file which contains the integration test app.
     *
     * This is relative to the root directory of the project.
     *
     * @experimental
     * @example
     *
     * "test/subdir/foo.integ.ts"
     */
    readonly entrypoint: string;
    /**
     * (experimental) The path of the tsconfig.json file to use when running integration test cdk apps.
     *
     * @experimental
     */
    readonly tsconfigPath: string;
    /**
     * (experimental) AWS CDK dependency manager.
     *
     * @experimental
     */
    readonly cdkDeps: AwsCdkDeps;
}
/**
 * (experimental) Cloud integration tests.
 *
 * @experimental
 */
export declare class IntegrationTest extends Component {
    /**
     * (experimental) Deploy the integration test and update the snapshot upon success.
     *
     * @experimental
     */
    readonly deployTask: Task;
    /**
     * (experimental) Destroys a deployed stack.
     *
     * @experimental
     */
    readonly destroyTask: Task;
    /**
     * (experimental) Synthesizes the integration test and compares against a local copy (runs during build).
     *
     * @experimental
     */
    readonly assertTask: Task;
    /**
     * (experimental) Just update snapshot (without deployment).
     *
     * @experimental
     */
    readonly snapshotTask: Task;
    /**
     * (experimental) The watch task.
     *
     * @experimental
     */
    readonly watchTask: Task;
    /**
     * @experimental
     */
    constructor(project: Project, options: IntegrationTestOptions);
}
