"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CdkTasks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
/**
 * (experimental) Adds standard AWS CDK tasks to your project.
 *
 * @experimental
 */
class CdkTasks extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project) {
        var _b;
        super(project);
        this.synth = project.addTask('synth', {
            description: 'Synthesizes your cdk app into cdk.out (part of "yarn build")',
            exec: 'cdk synth > /dev/null',
        });
        this.deploy = project.addTask('deploy', {
            description: 'Deploys your CDK app to the AWS cloud',
            exec: 'cdk deploy',
        });
        this.destroy = project.addTask('destroy', {
            description: 'Destroys your cdk app in the AWS cloud',
            exec: 'cdk destroy',
        });
        this.diff = project.addTask('diff', {
            description: 'Diffs the currently deployed app against your code',
            exec: 'cdk diff',
        });
        // typescript projects already have a "watch" task, we we will repurpose it
        const watch = (_b = project.tasks.tryFind('watch')) !== null && _b !== void 0 ? _b : project.addTask('watch');
        watch.reset();
        watch.description = 'Watches changes in your source code and rebuilds and deploys to the current account';
        // deploy first because surprisingly watch is not deploying first
        // see https://github.com/aws/aws-cdk/issues/17776
        watch.exec('cdk deploy --hotswap');
        // now we are ready to watch
        watch.exec('cdk watch');
        this.watch = watch;
    }
}
exports.CdkTasks = CdkTasks;
_a = JSII_RTTI_SYMBOL_1;
CdkTasks[_a] = { fqn: "projen.awscdk.CdkTasks", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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