"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalLevel = exports.CdkConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
const internal_1 = require("./internal");
/**
 * (experimental) Represents cdk.json file.
 *
 * @experimental
 */
class CdkConfig extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b, _c, _d, _e;
        super(project);
        this.cdkout = (_b = options.cdkout) !== null && _b !== void 0 ? _b : 'cdk.out';
        const context = { ...options.context };
        const fflags = (_c = options.featureFlags) !== null && _c !== void 0 ? _c : true;
        if (fflags) {
            for (const flag of internal_1.FEATURE_FLAGS) {
                context[flag] = true;
            }
        }
        this.json = new json_1.JsonFile(project, 'cdk.json', {
            omitEmpty: true,
            obj: {
                app: options.app,
                context: context,
                requireApproval: options.requireApproval,
                output: this.cdkout,
                build: options.buildCommand,
                watch: {
                    include: (_d = options.watchIncludes) !== null && _d !== void 0 ? _d : [],
                    exclude: (_e = options.watchExcludes) !== null && _e !== void 0 ? _e : [],
                },
            },
        });
        project.gitignore.exclude(`/${this.cdkout}/`);
        project.gitignore.exclude('.cdk.staging/');
    }
}
exports.CdkConfig = CdkConfig;
_a = JSII_RTTI_SYMBOL_1;
CdkConfig[_a] = { fqn: "projen.awscdk.CdkConfig", version: "0.46.3" };
/**
 * (experimental) Which approval is required when deploying CDK apps.
 *
 * @experimental
 */
var ApprovalLevel;
(function (ApprovalLevel) {
    ApprovalLevel["NEVER"] = "never";
    ApprovalLevel["ANY_CHANGE"] = "any-change";
    ApprovalLevel["BROADENING"] = "broadening";
})(ApprovalLevel = exports.ApprovalLevel || (exports.ApprovalLevel = {}));
//# sourceMappingURL=data:application/json;base64,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