import { Component } from '../component';
import { DependencyType } from '../dependencies';
import { Project } from '../project';
/**
 * (experimental) Options for `AwsCdkDeps`.
 *
 * @experimental
 */
export interface AwsCdkDepsCommonOptions {
    /**
     * (experimental) Minimum version of the AWS CDK to depend on.
     *
     * @default "2.1.0"
     * @experimental
     */
    readonly cdkVersion: string;
    /**
     * (experimental) Minimum version of the `constructs` library to depend on.
     *
     * @default - for CDK 1.x the default is "3.2.27", for CDK 2.x the default is
     * "10.0.5".
     * @experimental
     */
    readonly constructsVersion?: string;
    /**
     * (experimental) Use pinned version instead of caret version for CDK.
     *
     * You can use this to prevent yarn to mix versions for your CDK dependencies and to prevent auto-updates.
     * If you use experimental features this will let you define the moment you include breaking changes.
     *
     * @experimental
     */
    readonly cdkVersionPinning?: boolean;
    /**
     * (deprecated) Which AWS CDK modules (those that start with "@aws-cdk/") does this library require when consumed?
     *
     * @deprecated For CDK 2.x use 'peerDeps' instead
     */
    readonly cdkDependencies?: string[];
    /**
     * (deprecated) If this is enabled (default), all modules declared in `cdkDependencies` will be also added as normal `dependencies` (as well as `peerDependencies`).
     *
     * This is to ensure that downstream consumers actually have your CDK dependencies installed
     * when using npm < 7 or yarn, where peer dependencies are not automatically installed.
     * If this is disabled, `cdkDependencies` will be added to `devDependencies` to ensure
     * they are present during development.
     *
     * @default true
     * @deprecated Not supported in CDK v2.
     */
    readonly cdkDependenciesAsDeps?: boolean;
    /**
     * (deprecated) Install the @aws-cdk/assert library?
     *
     * @default - will be included by default for AWS CDK >= 1.0.0 < 2.0.0
     * @deprecated The
     * @aws-cdk /assertions (in V1) and included in `aws-cdk-lib` for V2.
     */
    readonly cdkAssert?: boolean;
    /**
     * (experimental) Install the @aws-cdk/assertions library?
     *
     * Only needed for CDK 1.x. If using CDK 2.x then
     * assertions is already included in 'aws-cdk-lib'
     *
     * @default - will be included by default for AWS CDK >= 1.111.0 < 2.0.0
     * @experimental
     */
    readonly cdkAssertions?: boolean;
    /**
     * (deprecated) AWS CDK modules required for testing.
     *
     * @deprecated For CDK 2.x use 'devDeps' instead
     */
    readonly cdkTestDependencies?: string[];
}
/**
 * @experimental
 */
export interface AwsCdkDepsOptions extends AwsCdkDepsCommonOptions {
    /**
     * (experimental) The type of dependency to use for runtime AWS CDK and `constructs` modules.
     *
     * For libraries, use peer dependencies and for apps use runtime dependencies.
     *
     * @experimental
     */
    readonly dependencyType: DependencyType;
}
/**
 * (experimental) Manages dependencies on the AWS CDK.
 *
 * @experimental
 */
export declare class AwsCdkDeps extends Component {
    /**
     * (experimental) The dependency requirement for AWS CDK (e.g. `^2.0.0`).
     *
     * @experimental
     */
    readonly cdkVersion: string;
    /**
     * (experimental) The minimum version of the AWS CDK (e.g. `2.0.0`).
     *
     * @experimental
     */
    readonly cdkMinimumVersion: string;
    /**
     * (deprecated) Whether CDK dependencies are added as normal dependencies (and peer dependencies).
     *
     * @deprecated Not used for CDK 2.x
     */
    readonly cdkDependenciesAsDeps: boolean;
    /**
     * (experimental) The major version of the AWS CDK (e.g. 1, 2, ...).
     *
     * @experimental
     */
    readonly cdkMajorVersion: number;
    private readonly dependencyType;
    /**
     * @experimental
     */
    constructor(project: Project, options: AwsCdkDepsOptions);
    /**
     * (experimental) Adds dependencies to AWS CDK modules.
     *
     * The type of dependency is determined by the `dependencyType` option.
     *
     * This method is not supported in CDK v2. Use `project.addPeerDeps()` or
     * `project.addDeps()` as appropriate.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @experimental
     */
    addV1Dependencies(...deps: string[]): void;
    /**
     * (experimental) Adds AWS CDK modules as dev dependencies.
     *
     * This method is not supported in CDK v2. Use `project.addPeerDeps()` or
     * `project.addDeps()` as appropriate.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @experimental
     */
    addV1DevDependencies(...deps: string[]): void;
    private addConstructsDependency;
    /**
     * Adds a dependency on the AWS CDK framework (e.g. `@aws-cdk/core` for V1 or `aws-cdk-lib` for V1).
     */
    private addFrameworkDependency;
    private addV1AssertionLibraryDependency;
    /**
     * Adds a set of dependencies with the user-specified dependency type.
     * @param deps The set of dependency specifications
     */
    private addV1DependenciesByType;
}
