"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructLibraryAws = exports.AwsCdkConstructLibrary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
const cdk_1 = require("../cdk");
const dependencies_1 = require("../dependencies");
const auto_discover_1 = require("./auto-discover");
const awscdk_deps_1 = require("./awscdk-deps");
/**
 * (experimental) AWS CDK construct library project.
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the AWS CDK with a friendly workflow and automatic publishing to
 * the construct catalog.
 *
 * @experimental
 * @pjid awscdk-construct
 */
class AwsCdkConstructLibrary extends cdk_1.ConstructLibrary {
    /**
     * @experimental
     */
    constructor(options) {
        var _c, _d;
        const cdkMajorVersion = (_c = semver.parse(options.cdkVersion)) === null || _c === void 0 ? void 0 : _c.major;
        super({
            peerDependencyOptions: cdkMajorVersion === 1 ? {
                pinnedDevDependency: false,
            } : undefined,
            workflowContainerImage: determineWorkflowContainerImage(options, cdkMajorVersion),
            ...options,
        });
        this.cdkDeps = new awscdk_deps_1.AwsCdkDeps(this, {
            // since this we are a library, dependencies should be added a peers
            dependencyType: dependencies_1.DependencyType.PEER,
            ...options,
        });
        const lambdaAutoDiscover = (_d = options.lambdaAutoDiscover) !== null && _d !== void 0 ? _d : true;
        if (lambdaAutoDiscover) {
            new auto_discover_1.AutoDiscover(this, {
                srcdir: this.srcdir,
                testdir: this.testdir,
                lambdaOptions: options.lambdaOptions,
                tsconfigPath: this.tsconfigDev.fileName,
                cdkDeps: this.cdkDeps,
            });
        }
    }
    /**
     * (experimental) The target CDK version for this library.
     *
     * @experimental
     */
    get cdkVersion() {
        return this.cdkDeps.cdkVersion;
    }
    /**
     * @deprecated use `cdkVersion`
     */
    get version() {
        return this.cdkVersion;
    }
    /**
     * (deprecated) Adds dependencies to AWS CDK modules.
     *
     * Since this is a library project, dependencies will be added as peer dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @deprecated Not supported in v2. For v1, use `project.cdkDeps.addV1Dependencies()`
     */
    addCdkDependencies(...deps) {
        return this.cdkDeps.addV1Dependencies(...deps);
    }
    /**
     * (deprecated) Adds AWS CDK modules as dev dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @deprecated Not supported in v2. For v1, use `project.cdkDeps.addV1DevDependencies()`
     */
    addCdkTestDependencies(...deps) {
        return this.cdkDeps.addV1DevDependencies(...deps);
    }
}
exports.AwsCdkConstructLibrary = AwsCdkConstructLibrary;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkConstructLibrary[_a] = { fqn: "projen.awscdk.AwsCdkConstructLibrary", version: "0.46.3" };
function determineWorkflowContainerImage(options, cdkMajorVersion) {
    // if the user specifies the workflow container image explicitly, use that
    if (options.workflowContainerImage) {
        return options.workflowContainerImage;
    }
    // if the user specifies minimum node version, then JsiiProject will take care of
    // determining the workflow container image from that, so we return "undefined"
    if (options.minNodeVersion) {
        return undefined;
    }
    // otherwise, choose a workflow container image based on the CDK version
    if (cdkMajorVersion === 1) {
        return 'jsii/superchain:1-buster-slim';
    }
    if (cdkMajorVersion === 2) {
        return 'jsii/superchain:1-buster-slim-node14';
    }
    return undefined;
}
/**
 * @deprecated use `AwsCdkConstructLibrary`
 */
class ConstructLibraryAws extends AwsCdkConstructLibrary {
}
exports.ConstructLibraryAws = ConstructLibraryAws;
_b = JSII_RTTI_SYMBOL_1;
ConstructLibraryAws[_b] = { fqn: "projen.awscdk.ConstructLibraryAws", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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