import { ConstructLibrary, ConstructLibraryOptions } from '../cdk';
import { AwsCdkDeps, AwsCdkDepsCommonOptions } from './awscdk-deps';
import { LambdaFunctionCommonOptions } from './lambda-function';
/**
 * (experimental) Options for `AwsCdkConstructLibrary`.
 *
 * @experimental
 */
export interface AwsCdkConstructLibraryOptions extends ConstructLibraryOptions, AwsCdkDepsCommonOptions {
    /**
     * (experimental) Automatically adds an `aws_lambda.Function` for each `.lambda.ts` handler in your source tree. If this is disabled, you either need to explicitly call `aws_lambda.Function.autoDiscover()` or define a `new aws_lambda.Function()` for each handler.
     *
     * @default true
     * @experimental
     */
    readonly lambdaAutoDiscover?: boolean;
    /**
     * (experimental) Common options for all AWS Lambda functions.
     *
     * @default - default options
     * @experimental
     */
    readonly lambdaOptions?: LambdaFunctionCommonOptions;
}
/**
 * (experimental) AWS CDK construct library project.
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the AWS CDK with a friendly workflow and automatic publishing to
 * the construct catalog.
 *
 * @experimental
 * @pjid awscdk-construct
 */
export declare class AwsCdkConstructLibrary extends ConstructLibrary {
    /**
     * @experimental
     */
    readonly cdkDeps: AwsCdkDeps;
    /**
     * @experimental
     */
    constructor(options: AwsCdkConstructLibraryOptions);
    /**
     * (experimental) The target CDK version for this library.
     *
     * @experimental
     */
    get cdkVersion(): string;
    /**
     * @deprecated use `cdkVersion`
     */
    get version(): string;
    /**
     * (deprecated) Adds dependencies to AWS CDK modules.
     *
     * Since this is a library project, dependencies will be added as peer dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @deprecated Not supported in v2. For v1, use `project.cdkDeps.addV1Dependencies()`
     */
    addCdkDependencies(...deps: string[]): void;
    /**
     * (deprecated) Adds AWS CDK modules as dev dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @deprecated Not supported in v2. For v1, use `project.cdkDeps.addV1DevDependencies()`
     */
    addCdkTestDependencies(...deps: string[]): void;
}
/**
 * @deprecated use `AwsCdkConstructLibraryOptions`
 */
export interface ConstructLibraryAwsOptions extends AwsCdkConstructLibraryOptions {
}
/**
 * @deprecated use `AwsCdkConstructLibrary`
 */
export declare class ConstructLibraryAws extends AwsCdkConstructLibrary {
}
