"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkTypeScriptApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
const typescript_1 = require("../typescript");
const auto_discover_1 = require("./auto-discover");
const awscdk_deps_1 = require("./awscdk-deps");
const cdk_config_1 = require("./cdk-config");
const cdk_tasks_1 = require("./cdk-tasks");
/**
 * (experimental) AWS CDK app in TypeScript.
 *
 * @experimental
 * @pjid awscdk-app-ts
 */
class AwsCdkTypeScriptApp extends typescript_1.TypeScriptAppProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g;
        super({
            ...options,
            sampleCode: false,
            bundlerOptions: {
                ...options.bundlerOptions,
                // we invoke the "bundle" task as part of the build step in cdk.json so
                // we don't want it to be added to the pre-compile phase.
                addToPreCompile: false,
            },
        });
        this.cdkDeps = new awscdk_deps_1.AwsCdkDeps(this, {
            dependencyType: dependencies_1.DependencyType.RUNTIME,
            ...options,
        });
        this.appEntrypoint = (_b = options.appEntrypoint) !== null && _b !== void 0 ? _b : 'main.ts';
        // CLI
        this.addDevDeps(`aws-cdk@${this.cdkDeps.cdkVersion}`);
        // no compile step because we do all of it in typescript directly
        this.compileTask.reset();
        this.cdkTasks = new cdk_tasks_1.CdkTasks(this);
        // add synth to the build
        this.postCompileTask.spawn(this.cdkTasks.synth);
        const tsConfigFile = (_c = this.tsconfig) === null || _c === void 0 ? void 0 : _c.fileName;
        if (!tsConfigFile) {
            throw new Error('Expecting tsconfig.json');
        }
        this.cdkConfig = new cdk_config_1.CdkConfig(this, {
            app: `npx ts-node -P ${tsConfigFile} --prefer-ts-exts ${path.posix.join(this.srcdir, this.appEntrypoint)}`,
            featureFlags: this.cdkDeps.cdkMajorVersion < 2,
            buildCommand: this.runTaskCommand(this.bundler.bundleTask),
            watchIncludes: [
                `${this.srcdir}/**/*.ts`,
                `${this.testdir}/**/*.ts`,
            ],
            watchExcludes: [
                'README.md',
                'cdk*.json',
                '**/*.d.ts',
                '**/*.js',
                'tsconfig.json',
                'package*.json',
                'yarn.lock',
                'node_modules',
            ],
            ...options,
        });
        this.gitignore.exclude('.parcel-cache/');
        (_d = this.npmignore) === null || _d === void 0 ? void 0 : _d.exclude(`${this.cdkConfig.cdkout}/`);
        (_e = this.npmignore) === null || _e === void 0 ? void 0 : _e.exclude('.cdk.staging/');
        if (this.tsconfig) {
            this.tsconfig.exclude.push(this.cdkConfig.cdkout);
        }
        this.addDevDeps('ts-node@^9');
        if ((_f = options.sampleCode) !== null && _f !== void 0 ? _f : true) {
            new SampleCode(this, this.cdkDeps.cdkMajorVersion);
        }
        const lambdaAutoDiscover = (_g = options.lambdaAutoDiscover) !== null && _g !== void 0 ? _g : true;
        if (lambdaAutoDiscover) {
            new auto_discover_1.AutoDiscover(this, {
                srcdir: this.srcdir,
                testdir: this.testdir,
                lambdaOptions: options.lambdaOptions,
                tsconfigPath: this.tsconfigDev.fileName,
                cdkDeps: this.cdkDeps,
            });
        }
    }
    /**
     * (experimental) The CDK version this app is using.
     *
     * @experimental
     */
    get cdkVersion() { return this.cdkDeps.cdkVersion; }
    /**
     * (experimental) Adds an AWS CDK module dependencies.
     *
     * @param modules The list of modules to depend on.
     * @experimental
     */
    addCdkDependency(...modules) {
        return this.cdkDeps.addV1Dependencies(...modules);
    }
}
exports.AwsCdkTypeScriptApp = AwsCdkTypeScriptApp;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkTypeScriptApp[_a] = { fqn: "projen.awscdk.AwsCdkTypeScriptApp", version: "0.46.3" };
class SampleCode extends component_1.Component {
    constructor(project, cdkMajorVersion) {
        super(project);
        this.cdkMajorVersion = cdkMajorVersion;
        this.appProject = project;
    }
    synthesize() {
        const outdir = this.project.outdir;
        const srcdir = path.join(outdir, this.appProject.srcdir);
        if (fs.pathExistsSync(srcdir) && fs.readdirSync(srcdir).filter(x => x.endsWith('.ts'))) {
            return;
        }
        const srcImports = new Array();
        if (this.cdkMajorVersion < 2) {
            srcImports.push('import { App, Construct, Stack, StackProps } from \'@aws-cdk/core\';');
        }
        else {
            srcImports.push('import { App, Stack, StackProps } from \'aws-cdk-lib\';');
            srcImports.push('import { Construct } from \'constructs\';');
        }
        const srcCode = `${srcImports.join('\n')}

export class MyStack extends Stack {
  constructor(scope: Construct, id: string, props: StackProps = {}) {
    super(scope, id, props);

    // define resources here...
  }
}

// for development, use account/region from cdk cli
const devEnv = {
  account: process.env.CDK_DEFAULT_ACCOUNT,
  region: process.env.CDK_DEFAULT_REGION,
};

const app = new App();

new MyStack(app, 'my-stack-dev', { env: devEnv });
// new MyStack(app, 'my-stack-prod', { env: prodEnv });

app.synth();`;
        fs.mkdirpSync(srcdir);
        fs.writeFileSync(path.join(srcdir, this.appProject.appEntrypoint), srcCode);
        const testdir = path.join(outdir, this.appProject.testdir);
        if (fs.pathExistsSync(testdir) && fs.readdirSync(testdir).filter(x => x.endsWith('.ts'))) {
            return;
        }
        const testImports = new Array();
        if (this.cdkMajorVersion < 2) {
            testImports.push('import { App } from \'@aws-cdk/core\';');
            testImports.push('import { Template } from \'@aws-cdk/assertions\';');
        }
        else {
            testImports.push('import { App } from \'aws-cdk-lib\';');
            testImports.push('import { Template } from \'aws-cdk-lib/assertions\';');
        }
        const appEntrypointName = path.basename(this.appProject.appEntrypoint, '.ts');
        const testCode = `${testImports.join('\n')}
import { MyStack } from '../src/${appEntrypointName}';

test('Snapshot', () => {
  const app = new App();
  const stack = new MyStack(app, 'test');

  const template = Template.fromStack(stack);
  expect(template.toJSON()).toMatchSnapshot();
});`;
        fs.mkdirpSync(testdir);
        fs.writeFileSync(path.join(testdir, `${appEntrypointName}.test.ts`), testCode);
    }
}
//# sourceMappingURL=data:application/json;base64,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