import { TypeScriptAppProject, TypeScriptProjectOptions } from '../typescript';
import { AwsCdkDeps, AwsCdkDepsCommonOptions } from './awscdk-deps';
import { CdkConfig, CdkConfigCommonOptions } from './cdk-config';
import { CdkTasks } from './cdk-tasks';
import { LambdaFunctionCommonOptions } from './lambda-function';
/**
 * @experimental
 */
export interface AwsCdkTypeScriptAppOptions extends TypeScriptProjectOptions, CdkConfigCommonOptions, AwsCdkDepsCommonOptions {
    /**
     * (experimental) The CDK app's entrypoint (relative to the source directory, which is "src" by default).
     *
     * @default "main.ts"
     * @experimental
     */
    readonly appEntrypoint?: string;
    /**
     * (experimental) Automatically adds an `awscdk.LambdaFunction` for each `.lambda.ts` handler in your source tree. If this is disabled, you can manually add an `awscdk.AutoDiscover` component to your project.
     *
     * @default true
     * @experimental
     */
    readonly lambdaAutoDiscover?: boolean;
    /**
     * (experimental) Common options for all AWS Lambda functions.
     *
     * @default - default options
     * @experimental
     */
    readonly lambdaOptions?: LambdaFunctionCommonOptions;
}
/**
 * (experimental) AWS CDK app in TypeScript.
 *
 * @experimental
 * @pjid awscdk-app-ts
 */
export declare class AwsCdkTypeScriptApp extends TypeScriptAppProject {
    /**
     * (experimental) The CDK version this app is using.
     *
     * @experimental
     */
    get cdkVersion(): string;
    /**
     * (experimental) The CDK app entrypoint.
     *
     * @experimental
     */
    readonly appEntrypoint: string;
    /**
     * (experimental) Common CDK tasks.
     *
     * @experimental
     */
    readonly cdkTasks: CdkTasks;
    /**
     * (experimental) cdk.json configuration.
     *
     * @experimental
     */
    readonly cdkConfig: CdkConfig;
    /**
     * @experimental
     */
    readonly cdkDeps: AwsCdkDeps;
    /**
     * @experimental
     */
    constructor(options: AwsCdkTypeScriptAppOptions);
    /**
     * (experimental) Adds an AWS CDK module dependencies.
     *
     * @param modules The list of modules to depend on.
     * @experimental
     */
    addCdkDependency(...modules: string[]): void;
}
