"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoDiscover = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const glob = require("glob");
const component_1 = require("../component");
const integration_test_1 = require("./integration-test");
const internal_1 = require("./internal");
const lambda_function_1 = require("./lambda-function");
/**
 * (experimental) Automatically creates a `LambdaFunction` for all `.lambda.ts` files under the source directory of the project.
 *
 * @experimental
 */
class AutoDiscover extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        super(project);
        this.autoDiscoverLambdaFunctions(options);
        this.autoDiscoverIntegrationTests(options);
    }
    autoDiscoverLambdaFunctions(options) {
        const entrypoints = glob.sync(`**/*${internal_1.TYPESCRIPT_LAMBDA_EXT}`, {
            cwd: path_1.join(this.project.outdir, options.srcdir),
        });
        for (const entrypoint of entrypoints) {
            new lambda_function_1.LambdaFunction(this.project, {
                entrypoint: path_1.join(options.srcdir, entrypoint),
                cdkDeps: options.cdkDeps,
                ...options.lambdaOptions,
            });
        }
    }
    autoDiscoverIntegrationTests(options) {
        const entrypoints = glob.sync(`**/*${internal_1.TYPESCRIPT_INTEG_EXT}`, {
            cwd: path_1.join(this.project.outdir, options.testdir),
        });
        for (const entrypoint of entrypoints) {
            new integration_test_1.IntegrationTest(this.project, {
                entrypoint: path_1.join(options.testdir, entrypoint),
                cdkDeps: options.cdkDeps,
                tsconfigPath: options.tsconfigPath,
            });
        }
    }
}
exports.AutoDiscover = AutoDiscover;
_a = JSII_RTTI_SYMBOL_1;
AutoDiscover[_a] = { fqn: "projen.awscdk.AutoDiscover", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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