import { Component } from '../component';
import { Project } from '../project';
import { AwsCdkDeps } from './awscdk-deps';
import { LambdaFunctionCommonOptions } from './lambda-function';
/**
 * (experimental) Options for `AutoDiscover`.
 *
 * @experimental
 */
export interface AutoDiscoverOptions {
    /**
     * (experimental) Options for auto-discovery of AWS Lambda functions.
     *
     * @experimental
     */
    readonly lambdaOptions?: LambdaFunctionCommonOptions;
    /**
     * (experimental) Project source tree (relative to project output directory).
     *
     * @experimental
     */
    readonly srcdir: string;
    /**
     * (experimental) Test source tree.
     *
     * @experimental
     */
    readonly testdir: string;
    /**
     * (experimental) Path to the tsconfig file to use for integration tests.
     *
     * @experimental
     */
    readonly tsconfigPath: string;
    /**
     * (experimental) AWS CDK dependency manager.
     *
     * @experimental
     */
    readonly cdkDeps: AwsCdkDeps;
}
/**
 * (experimental) Automatically creates a `LambdaFunction` for all `.lambda.ts` files under the source directory of the project.
 *
 * @experimental
 */
export declare class AutoDiscover extends Component {
    /**
     * @experimental
     */
    constructor(project: Project, options: AutoDiscoverOptions);
    private autoDiscoverLambdaFunctions;
    private autoDiscoverIntegrationTests;
}
