# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['temporalio',
 'temporalio.api',
 'temporalio.api.command',
 'temporalio.api.command.v1',
 'temporalio.api.common',
 'temporalio.api.common.v1',
 'temporalio.api.dependencies',
 'temporalio.api.dependencies.gogoproto',
 'temporalio.api.enums',
 'temporalio.api.enums.v1',
 'temporalio.api.errordetails',
 'temporalio.api.errordetails.v1',
 'temporalio.api.failure',
 'temporalio.api.failure.v1',
 'temporalio.api.filter',
 'temporalio.api.filter.v1',
 'temporalio.api.history',
 'temporalio.api.history.v1',
 'temporalio.api.namespace',
 'temporalio.api.namespace.v1',
 'temporalio.api.query',
 'temporalio.api.query.v1',
 'temporalio.api.replication',
 'temporalio.api.replication.v1',
 'temporalio.api.taskqueue',
 'temporalio.api.taskqueue.v1',
 'temporalio.api.version',
 'temporalio.api.version.v1',
 'temporalio.api.workflow',
 'temporalio.api.workflow.v1',
 'temporalio.api.workflowservice',
 'temporalio.api.workflowservice.v1',
 'temporalio.bridge',
 'temporalio.bridge.proto',
 'temporalio.bridge.proto.activity_result',
 'temporalio.bridge.proto.activity_task',
 'temporalio.bridge.proto.bridge',
 'temporalio.bridge.proto.child_workflow',
 'temporalio.bridge.proto.common',
 'temporalio.bridge.proto.external_data',
 'temporalio.bridge.proto.workflow_activation',
 'temporalio.bridge.proto.workflow_commands',
 'temporalio.bridge.proto.workflow_completion']

package_data = \
{'': ['*'],
 'temporalio.bridge': ['sdk-core/*',
                       'sdk-core/.buildkite/*',
                       'sdk-core/.buildkite/docker/*',
                       'sdk-core/.cargo/*',
                       'sdk-core/arch_docs/*',
                       'sdk-core/arch_docs/diagrams/*',
                       'sdk-core/bridge-ffi/*',
                       'sdk-core/bridge-ffi/include/*',
                       'sdk-core/bridge-ffi/src/*',
                       'sdk-core/client/*',
                       'sdk-core/client/src/*',
                       'sdk-core/core-api/*',
                       'sdk-core/core-api/src/*',
                       'sdk-core/core/*',
                       'sdk-core/core/benches/*',
                       'sdk-core/core/src/*',
                       'sdk-core/core/src/core_tests/*',
                       'sdk-core/core/src/pollers/*',
                       'sdk-core/core/src/protosext/*',
                       'sdk-core/core/src/replay/*',
                       'sdk-core/core/src/telemetry/*',
                       'sdk-core/core/src/test_help/*',
                       'sdk-core/core/src/worker/*',
                       'sdk-core/core/src/worker/activities/*',
                       'sdk-core/core/src/workflow/*',
                       'sdk-core/core/src/workflow/machines/*',
                       'sdk-core/core/src/workflow/machines/workflow_machines/*',
                       'sdk-core/core/src/workflow/workflow_tasks/*',
                       'sdk-core/etc/*',
                       'sdk-core/fsm/*',
                       'sdk-core/fsm/rustfsm_procmacro/*',
                       'sdk-core/fsm/rustfsm_procmacro/src/*',
                       'sdk-core/fsm/rustfsm_procmacro/tests/*',
                       'sdk-core/fsm/rustfsm_procmacro/tests/trybuild/*',
                       'sdk-core/fsm/rustfsm_trait/*',
                       'sdk-core/fsm/rustfsm_trait/src/*',
                       'sdk-core/fsm/src/*',
                       'sdk-core/histories/*',
                       'sdk-core/protos/api_upstream/*',
                       'sdk-core/protos/api_upstream/.buildkite/*',
                       'sdk-core/protos/api_upstream/.github/*',
                       'sdk-core/protos/api_upstream/dependencies/gogoproto/*',
                       'sdk-core/protos/api_upstream/temporal/api/command/v1/*',
                       'sdk-core/protos/api_upstream/temporal/api/common/v1/*',
                       'sdk-core/protos/api_upstream/temporal/api/enums/v1/*',
                       'sdk-core/protos/api_upstream/temporal/api/errordetails/v1/*',
                       'sdk-core/protos/api_upstream/temporal/api/failure/v1/*',
                       'sdk-core/protos/api_upstream/temporal/api/filter/v1/*',
                       'sdk-core/protos/api_upstream/temporal/api/history/v1/*',
                       'sdk-core/protos/api_upstream/temporal/api/namespace/v1/*',
                       'sdk-core/protos/api_upstream/temporal/api/query/v1/*',
                       'sdk-core/protos/api_upstream/temporal/api/replication/v1/*',
                       'sdk-core/protos/api_upstream/temporal/api/taskqueue/v1/*',
                       'sdk-core/protos/api_upstream/temporal/api/version/v1/*',
                       'sdk-core/protos/api_upstream/temporal/api/workflow/v1/*',
                       'sdk-core/protos/api_upstream/temporal/api/workflowservice/v1/*',
                       'sdk-core/protos/local/temporal/sdk/core/*',
                       'sdk-core/protos/local/temporal/sdk/core/activity_result/*',
                       'sdk-core/protos/local/temporal/sdk/core/activity_task/*',
                       'sdk-core/protos/local/temporal/sdk/core/bridge/*',
                       'sdk-core/protos/local/temporal/sdk/core/child_workflow/*',
                       'sdk-core/protos/local/temporal/sdk/core/common/*',
                       'sdk-core/protos/local/temporal/sdk/core/external_data/*',
                       'sdk-core/protos/local/temporal/sdk/core/workflow_activation/*',
                       'sdk-core/protos/local/temporal/sdk/core/workflow_commands/*',
                       'sdk-core/protos/local/temporal/sdk/core/workflow_completion/*',
                       'sdk-core/sdk-core-protos/*',
                       'sdk-core/sdk-core-protos/src/*',
                       'sdk-core/sdk/*',
                       'sdk-core/sdk/src/*',
                       'sdk-core/sdk/src/workflow_context/*',
                       'sdk-core/test-utils/*',
                       'sdk-core/test-utils/src/*',
                       'sdk-core/tests/*',
                       'sdk-core/tests/integ_tests/*',
                       'sdk-core/tests/integ_tests/workflow_tests/*',
                       'src/*']}

install_requires = \
['dacite>=1.6.0,<2.0.0',
 'grpcio>=1.43.0,<2.0.0',
 'protobuf>=3.19.4,<4.0.0',
 'types-protobuf>=3.19.6,<4.0.0',
 'typing-extensions>=4.0.1,<5.0.0']

setup_kwargs = {
    'name': 'temporalio',
    'version': '0.1a1',
    'description': 'Temporal.io Python SDK',
    'long_description': '# Temporal Python SDK\n\n**UNDER DEVELOPMENT**\n\nThe Python SDK is under development. There are no compatibility guarantees nor proper documentation pages at this time.\n\n## Usage\n\n### Installation\n\nInstall the `temporalio` package from [PyPI](https://pypi.org/project/temporalio). If using `pip` directly, this might\nlook like:\n\n    python -m pip install temporalio\n\n### Client\n\nA client can be created and used to start a workflow like so:\n\n```python\nfrom temporalio.client import Client\n\nasync def main():\n  # Create client connected to server at the given address\n  client = await Client.connect("http://localhost:7233", namespace="my-namespace")\n\n  # Start a workflow\n  handle = await client.start_workflow("my workflow name", "some arg", id="my-workflow-id", task_queue="my-task-queue")\n\n  # Wait for result\n  result = await handle.result()\n  print(f"Result: {result}")\n```\n\nSome things to note about the above code:\n\n* A `Client` does not have an explicit "close"\n* Positional arguments can be passed to `start_workflow`\n* The `handle` represents the workflow that was started and can be used for more than just getting the result\n* Since we are just getting the handle and waiting on the result, we could have called `client.execute_workflow` which\n  does the same thing\n* Clients can have many more options not shown here (e.g. data converters and interceptors)\n\n#### Data Conversion\n\nData converters are used to convert raw Temporal payloads to/from actual Python types. A custom data converter of type\n`temporalio.converter.DataConverter` can be set via the `data_converter` client parameter.\n\nThe default data converter supports converting multiple types including:\n\n* `None`\n* `bytes`\n* `google.protobuf.message.Message` - As JSON when encoding, but has ability to decode binary proto from other languages\n* Anything that [`json.dump`](https://docs.python.org/3/library/json.html#json.dump) supports\n\nAs a special case in the default converter, [data classes](https://docs.python.org/3/library/dataclasses.html) are\nautomatically [converted to dictionaries](https://docs.python.org/3/library/dataclasses.html#dataclasses.asdict) before\nencoding as JSON. Since Python is a dynamic language, when decoding via\n[`json.load`](https://docs.python.org/3/library/json.html#json.load), the type is not known at runtime so, for example,\na JSON object will be a `dict`. As a special case, if the parameter type hint is a data class for a JSON payload, it is\ndecoded into an instance of that data class (properly recursing into child data classes).\n\n### Activities\n\n#### Activity-only Worker\n\nAn activity-only worker can be started like so:\n\n```python\nimport asyncio\nimport logging\nfrom temporalio.client import Client\nfrom temporalio.worker import Worker\n\nasync def say_hello_activity(name: str) -> str:\n    return f"Hello, {name}!"\n\n\nasync def main(stop_event: asyncio.Event):\n  # Create client connected to server at the given address\n  client = await Client.connect("http://localhost:7233", namespace="my-namespace")\n\n  # Run the worker until the event is set\n  worker = Worker(client, task_queue="my-task-queue", activities={"say-hello-activity": say_hello_activity})\n  async with worker:\n    await stop_event.wait()\n```\n\nSome things to note about the above code:\n\n* This creates/uses the same client that is used for starting workflows\n* The `say_hello_activity` is `async` which is the recommended activity type (see "Types of Activities" below)\n* The created worker only runs activities, not workflows\n* Activities are passed as a mapping with the key as a string activity name and the value as a callable\n* While this example accepts a stop event and uses `async with`, `run()` and `shutdown()` may be used instead\n* Workers can have many more options not shown here (e.g. data converters and interceptors)\n\n#### Types of Activities\n\nThere are 3 types of activity callables accepted and described below: asynchronous, synchronous multithreaded, and\nsynchronous multiprocess/other. Only positional parameters are allowed in activity callables.\n\n##### Asynchronous Activities\n\nAsynchronous activities, i.e. functions using `async def`, are the recommended activity type. When using asynchronous\nactivities no special worker parameters are needed.\n\nCancellation for asynchronous activities is done via\n[`asyncio.Task.cancel`](https://docs.python.org/3/library/asyncio-task.html#asyncio.Task.cancel). This means that\n`asyncio.CancelledError` will be raised (and can be caught, but it is not recommended). An activity must heartbeat to\nreceive cancellation and there are other ways to be notified about cancellation (see "Activity Context" and\n"Heartbeating and Cancellation" later).\n\n##### Synchronous Activities\n\nSynchronous activities, i.e. functions that do not have `async def`, can be used with workers, but the\n`activity_executor` worker parameter must be set with a `concurrent.futures.Executor` instance to use for executing the\nactivities.\n\nCancellation for synchronous activities is done in the background and the activity must choose to listen for it and\nreact appropriately. An activity must heartbeat to receive cancellation and there are other ways to be notified about\ncancellation (see "Activity Context" and "Heartbeating and Cancellation" later).\n\n###### Synchronous Multithreaded Activities\n\nIf `activity_executor` is set to an instance of `concurrent.futures.ThreadPoolExecutor` then the synchronous activities\nare considered multithreaded activities. Besides `activity_executor`, no other worker parameters are required for\nsynchronous multithreaded activities.\n\n###### Synchronous Multiprocess/Other Activities\n\nSynchronous activities, i.e. functions that do not have `async def`, can be used with workers, but the\n`activity_executor` worker parameter must be set with a `concurrent.futures.Executor` instance to use for executing the\nactivities. If this is _not_ set to an instance of `concurrent.futures.ThreadPoolExecutor` then the synchronous\nactivities are considered multiprocess/other activities.\n\nThese require special primitives for heartbeating and cancellation. The `shared_state_manager` worker parameter must be\nset to an instance of `temporalio.worker.SharedStateManager`. The most common implementation can be created by passing a\n`multiprocessing.managers.SyncManager` (i.e. result of `multiprocessing.managers.Manager()`) to\n`temporalio.worker.SharedStateManager.create_from_multiprocessing()`.\n\nAlso, all of these activity functions must be\n["picklable"](https://docs.python.org/3/library/pickle.html#what-can-be-pickled-and-unpickled).\n\n#### Activity Context\n\nDuring activity execution, an implicit activity context is set as a\n[context variable](https://docs.python.org/3/library/contextvars.html). The context variable itself is not visible, but\ncalls in the `temporalio.activity` package make use of it. Specifically:\n\n* `in_activity()` - Whether an activity context is present\n* `info()` - Returns the immutable info of the currently running activity\n* `heartbeat(*details)` - Record a heartbeat\n* `is_cancelled()` - Whether a cancellation has been requested on this activity\n* `wait_for_cancelled()` - `async` call to wait for cancellation request\n* `wait_for_cancelled_sync(timeout)` - Synchronous blocking call to wait for cancellation request\n* `is_worker_shutdown()` - Whether the worker has started graceful shutdown\n* `wait_for_worker_shutdown()` - `async` call to wait for start of graceful worker shutdown\n* `wait_for_worker_shutdown_sync(timeout)` - Synchronous blocking call to wait for start of graceful worker shutdown\n* `raise_complete_async()` - Raise an error that this activity will be completed asynchronously (i.e. after return of\n  the activity function in a separate client call)\n\nWith the exception of `in_activity()`, if any of the functions are called outside of an activity context, an error\noccurs. Synchronous activities cannot call any of the `async` functions.\n\n##### Heartbeating and Cancellation\n\nIn order for an activity to be notified of cancellation requests, they must invoke `temporalio.activity.heartbeat()`.\nIt is strongly recommended that all but the fastest executing activities call this function regularly. "Types of\nActivities" has specifics on cancellation for asynchronous and synchronous activities.\n\nIn addition to obtaining cancellation information, heartbeats also support detail data that is persisted on the server\nfor retrieval during activity retry. If an activity calls `temporalio.activity.heartbeat(123, 456)` and then fails and\nis retried, `temporalio.activity.info().heartbeat_details` will return an iterable containing `123` and `456` on the\nnext run.\n\n##### Worker Shutdown\n\nAn activity can react to a worker shutdown. Using `is_worker_shutdown` or one of the `wait_for_worker_shutdown`\nfunctions an activity can react to a shutdown.\n\nWhen the `graceful_shutdown_timeout` worker parameter is given a `datetime.timedelta`, on shutdown the worker will\nnotify activities of the graceful shutdown. Once that timeout has passed (or if wasn\'t set), the worker will perform\ncancellation of all outstanding activities.\n\nThe `shutdown()` invocation will wait on all activities to complete, so if a long-running activity does not at least\nrespect cancellation, the shutdown may never complete.\n\n## Development\n\nThe Python SDK is built to work with Python 3.7 and newer. It is built using\n[SDK Core](https://github.com/temporalio/sdk-core/) which is written in Rust.\n\n### Local development environment\n\n- Install the system dependencies:\n\n  - Python >=3.7\n  - [pipx](https://github.com/pypa/pipx#install-pipx) (only needed for installing the two dependencies below)\n  - [poetry](https://github.com/python-poetry/poetry) `pipx install poetry`\n  - [poe](https://github.com/nat-n/poethepoet) `pipx install poethepoet`\n\n- Use a local virtual env environment (helps IDEs and Windows):\n\n  ```bash\n  poetry config virtualenvs.in-project true\n  ```\n\n- Install the package dependencies (requires Rust):\n\n  ```bash\n  poetry install\n  ```\n\n- Build the project (requires Rust):\n\n  ```bash\n  poe build-develop\n  ```\n\n- Run the tests (requires Go):\n\n  ```bash\n  poe test\n  ```',
    'author': 'Temporal Technologies Inc',
    'author_email': 'sdk@temporal.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/temporalio/sdk-python',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}
from build import *
build(setup_kwargs)

setup(**setup_kwargs)
