"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimpleLambdaEdge = exports.SelectOriginByViwerCountry = exports.DefaultDirIndex = exports.Custom = exports.SecurtyHeaders = exports.AntiHotlinking = exports.ModifyResponseHeader = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cf = require("@aws-cdk/aws-cloudfront");
const lambda = require("@aws-cdk/aws-lambda");
const aws_lambda_nodejs_1 = require("@aws-cdk/aws-lambda-nodejs");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
/**
 * The directory for all extensions lambda assets
 */
const EXTENSION_ASSETS_PATH = path.join(__dirname, '../lambda-assets/extensions');
;
/**
 * The modify response header extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/modify-response-header
 * @stability stable
 */
class ModifyResponseHeader extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/modify-response-header',
            semanticVersion: '1.0.0',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.ModifyResponseHeaderFunctionARN').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
    }
}
exports.ModifyResponseHeader = ModifyResponseHeader;
_a = JSII_RTTI_SYMBOL_1;
ModifyResponseHeader[_a] = { fqn: "cdk-cloudfront-plus.ModifyResponseHeader", version: "0.1.17" };
/**
 * The Anti-Hotlinking extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/anti-hotlinking
 * @stability stable
 */
class AntiHotlinking extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/anti-hotlinking',
            semanticVersion: '1.2.5',
            parameters: {
                RefererList: props.referer.join(','),
            },
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.AntiHotlinking').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.VIEWER_REQUEST;
    }
}
exports.AntiHotlinking = AntiHotlinking;
_b = JSII_RTTI_SYMBOL_1;
AntiHotlinking[_b] = { fqn: "cdk-cloudfront-plus.AntiHotlinking", version: "0.1.17" };
/**
 * Security Headers extension.
 *
 * @see https://aws.amazon.com/tw/blogs/networking-and-content-delivery/adding-http-security-headers-using-lambdaedge-and-amazon-cloudfront/
 * @stability stable
 */
class SecurtyHeaders extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/add-security-headers',
            semanticVersion: '1.0.0',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.AddSecurityHeaderFunction').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
    }
}
exports.SecurtyHeaders = SecurtyHeaders;
_c = JSII_RTTI_SYMBOL_1;
SecurtyHeaders[_c] = { fqn: "cdk-cloudfront-plus.SecurtyHeaders", version: "0.1.17" };
/**
 * Custom extension sample.
 *
 * @stability stable
 */
class Custom extends cdk.NestedStack {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _h, _j, _k, _l, _m, _o;
        super(scope, id, props);
        this.props = props;
        const func = (_h = props === null || props === void 0 ? void 0 : props.func) !== null && _h !== void 0 ? _h : new lambda.Function(this, 'CustomFunc', {
            code: (_j = props === null || props === void 0 ? void 0 : props.code) !== null && _j !== void 0 ? _j : lambda.Code.fromAsset(path.join(__dirname, '../lambda/function')),
            runtime: (_k = props === null || props === void 0 ? void 0 : props.runtime) !== null && _k !== void 0 ? _k : lambda.Runtime.PYTHON_3_8,
            handler: (_l = props === null || props === void 0 ? void 0 : props.handler) !== null && _l !== void 0 ? _l : 'index.lambda_handler',
            timeout: (_m = props === null || props === void 0 ? void 0 : props.timeout) !== null && _m !== void 0 ? _m : cdk.Duration.seconds(5),
        });
        this.functionArn = func.functionArn;
        this.functionVersion = func.currentVersion;
        this.eventType = (_o = props === null || props === void 0 ? void 0 : props.eventType) !== null && _o !== void 0 ? _o : cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
        this._addDescription();
        this._outputSolutionId();
    }
    _addDescription() {
        this.templateOptions.description = `(${this.props.solutionId}) ${this.props.templateDescription}`;
    }
    _outputSolutionId() {
        if (this.props.solutionId) {
            new cdk.CfnOutput(this, 'SolutionId', {
                value: this.props.solutionId,
                description: 'Solution ID',
            });
        }
    }
}
exports.Custom = Custom;
_d = JSII_RTTI_SYMBOL_1;
Custom[_d] = { fqn: "cdk-cloudfront-plus.Custom", version: "0.1.17" };
/**
 * Generate a lambda function version from the given function ARN
 * @param scope
 * @param id
 * @param functionArn The lambda function ARN
 * @returns lambda.Version
 */
function bumpFunctionVersion(scope, id, functionArn) {
    return new lambda.Version(scope, `LambdaVersion${id}`, {
        lambda: lambda.Function.fromFunctionArn(scope, `FuncArn${id}`, functionArn),
    });
}
/**
 * Default Directory Indexes in Amazon S3-backed Amazon CloudFront Origins.
 *
 * use case - see https://aws.amazon.com/tw/blogs/compute/implementing-default-directory-indexes-in-amazon-s3-backed-amazon-cloudfront-origins-using-lambdaedge/
 *
 * @stability stable
 */
class DefaultDirIndex extends Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'DefaultDirIndexFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-default-dir-index/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'SO8134',
            templateDescription: 'Cloudfront extension with AWS CDK - Default Directory Index for Amazon S3 Origin.',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.DefaultDirIndex = DefaultDirIndex;
_e = JSII_RTTI_SYMBOL_1;
DefaultDirIndex[_e] = { fqn: "cdk-cloudfront-plus.DefaultDirIndex", version: "0.1.17" };
;
/**
 * selective origin by viewer counry.
 *
 * @stability stable
 */
class SelectOriginByViwerCountry extends Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'SelectOriginViewerCountryFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/select-origin-by-viewer-country/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
            bundling: {
                define: {
                    'process.env.COUNTRY_CODE_TABLE': jsonStringifiedBundlingDefinition(props.countryTable),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: '',
            templateDescription: 'Cloudfront extension with AWS CDK - Selective Origin by Viewer Country',
        });
    }
}
exports.SelectOriginByViwerCountry = SelectOriginByViwerCountry;
_f = JSII_RTTI_SYMBOL_1;
SelectOriginByViwerCountry[_f] = { fqn: "cdk-cloudfront-plus.SelectOriginByViwerCountry", version: "0.1.17" };
;
/**
 * Simple content generation.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/simple-lambda-edge
 * @stability stable
 */
class SimpleLambdaEdge extends Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'SimpleLambdaEdgeFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/simple-lambda-edge/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.VIEWER_REQUEST,
            solutionId: '',
            templateDescription: 'Cloudfront extension with AWS CDK - Simple Lambda Edge.',
        });
    }
}
exports.SimpleLambdaEdge = SimpleLambdaEdge;
_g = JSII_RTTI_SYMBOL_1;
SimpleLambdaEdge[_g] = { fqn: "cdk-cloudfront-plus.SimpleLambdaEdge", version: "0.1.17" };
;
function jsonStringifiedBundlingDefinition(value) {
    return JSON.stringify(value)
        .replace(/"/g, '\\"')
        .replace(/,/g, '\\,');
}
//# sourceMappingURL=data:application/json;base64,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