"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cf = require("@aws-cdk/aws-cloudfront");
const origins = require("@aws-cdk/aws-cloudfront-origins");
const cdk = require("@aws-cdk/core");
const extensions = require("../../extensions");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'select-origin-by-country');
// create the cloudfront distribution with extension(s)
const ext = new extensions.SelectOriginByViwerCountry(stack, 'SelectOriginByCountryCode', {
    countryTable: {
        CN: 'amazonaws.cn',
        US: 'twitter.com',
    },
});
const policy = new cf.OriginRequestPolicy(stack, 'OrigReqPolicy', {
    headerBehavior: cf.OriginRequestHeaderBehavior.allowList('cloudfront-viewer-country'),
});
// create the cloudfront distribution with extension(s)
const dist = new cf.Distribution(stack, 'dist', {
    defaultBehavior: {
        origin: new origins.HttpOrigin('aws.amazon.com'),
        edgeLambdas: [ext],
        originRequestPolicy: {
            originRequestPolicyId: policy.originRequestPolicyId,
        },
    },
});
new cdk.CfnOutput(stack, 'distributionDomainName', {
    value: dist.distributionDomainName,
});
//# sourceMappingURL=data:application/json;base64,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