"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
require("@aws-cdk/assert/jest");
const cf = require("@aws-cdk/aws-cloudfront");
const origins = require("@aws-cdk/aws-cloudfront-origins");
const cdk = require("@aws-cdk/core");
const extensions = require("../extensions");
test('minimal usage', () => {
    // GIVEN
    const app = new cdk.App();
    const stack = new cdk.Stack(app, 'demo-stack');
    // WHEN
    // create the cloudfront distribution with extension(s)
    const ext = new extensions.SelectOriginByViwerCountry(stack, 'SelectOriginByCountryCode', {
        countryTable: {
            US: 'mock-api.com',
            CN: 'mock-api.com.cn',
        },
    });
    const policy = new cf.OriginRequestPolicy(stack, 'OrigReqPolicy', {
        headerBehavior: cf.OriginRequestHeaderBehavior.allowList('cloudfront-viewer-country'),
    });
    // create the cloudfront distribution with extension(s)
    const dist = new cf.Distribution(stack, 'dist', {
        defaultBehavior: {
            origin: new origins.HttpOrigin('aws.amazon.com'),
            edgeLambdas: [ext],
            originRequestPolicy: {
                originRequestPolicyId: policy.originRequestPolicyId,
            },
        },
    });
    new cdk.CfnOutput(stack, 'distributionDomainName', {
        value: dist.distributionDomainName,
    });
    // THEN
    expect(assert_1.SynthUtils.synthesize(stack).template).toMatchSnapshot();
    expect(stack).toHaveResourceLike('AWS::CloudFront::Distribution', {
        DistributionConfig: {
            DefaultCacheBehavior: {
                LambdaFunctionAssociations: [
                    {
                        EventType: 'origin-request',
                        LambdaFunctionARN: {
                            Ref: 'SelectOriginViewerCountryFuncCurrentVersion32A1D59B0e2ad5c9ee3b77e9947b080cb3c186c1',
                        },
                    },
                ],
                ViewerProtocolPolicy: 'allow-all',
            },
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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