# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq import util


class ManagementJSStreamParam(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(
        self,
        max_age: int = None,
        max_bytes: int = None,
        max_consumers: int = None,
        max_msg_size: int = None,
        max_msgs: int = None,
        max_msgs_per_subject: int = None,
        name: str = None,
        subjects: List[str] = None,
    ):
        """ManagementJSStreamParam - a model defined in OpenAPI

        :param max_age: The max_age of this ManagementJSStreamParam.
        :param max_bytes: The max_bytes of this ManagementJSStreamParam.
        :param max_consumers: The max_consumers of this ManagementJSStreamParam.
        :param max_msg_size: The max_msg_size of this ManagementJSStreamParam.
        :param max_msgs: The max_msgs of this ManagementJSStreamParam.
        :param max_msgs_per_subject: The max_msgs_per_subject of this ManagementJSStreamParam.
        :param name: The name of this ManagementJSStreamParam.
        :param subjects: The subjects of this ManagementJSStreamParam.
        """
        self.openapi_types = {
            "max_age": int,
            "max_bytes": int,
            "max_consumers": int,
            "max_msg_size": int,
            "max_msgs": int,
            "max_msgs_per_subject": int,
            "name": str,
            "subjects": List[str],
        }

        self.attribute_map = {
            "max_age": "max_age",
            "max_bytes": "max_bytes",
            "max_consumers": "max_consumers",
            "max_msg_size": "max_msg_size",
            "max_msgs": "max_msgs",
            "max_msgs_per_subject": "max_msgs_per_subject",
            "name": "name",
            "subjects": "subjects",
        }

        self._max_age = max_age
        self._max_bytes = max_bytes
        self._max_consumers = max_consumers
        self._max_msg_size = max_msg_size
        self._max_msgs = max_msgs
        self._max_msgs_per_subject = max_msgs_per_subject
        self._name = name
        self._subjects = subjects

    @classmethod
    def from_dict(cls, dikt: dict) -> "ManagementJSStreamParam":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The management.JSStreamParam of this ManagementJSStreamParam.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def max_age(self):
        """Gets the max_age of this ManagementJSStreamParam.

        MaxAge is the max duration (ns) the stream will store a message  Messages breaching the limit will be removed.

        :return: The max_age of this ManagementJSStreamParam.
        :rtype: int
        """
        return self._max_age

    @max_age.setter
    def max_age(self, max_age):
        """Sets the max_age of this ManagementJSStreamParam.

        MaxAge is the max duration (ns) the stream will store a message  Messages breaching the limit will be removed.

        :param max_age: The max_age of this ManagementJSStreamParam.
        :type max_age: int
        """

        self._max_age = max_age

    @property
    def max_bytes(self):
        """Gets the max_bytes of this ManagementJSStreamParam.

        MaxBytes is the max number of message bytes the stream will store.  Oldest messages are removed once limit breached.

        :return: The max_bytes of this ManagementJSStreamParam.
        :rtype: int
        """
        return self._max_bytes

    @max_bytes.setter
    def max_bytes(self, max_bytes):
        """Sets the max_bytes of this ManagementJSStreamParam.

        MaxBytes is the max number of message bytes the stream will store.  Oldest messages are removed once limit breached.

        :param max_bytes: The max_bytes of this ManagementJSStreamParam.
        :type max_bytes: int
        """
        if max_bytes is not None and max_bytes < -1:
            raise ValueError(
                "Invalid value for `max_bytes`, must be a value greater than or equal to `-1`"
            )

        self._max_bytes = max_bytes

    @property
    def max_consumers(self):
        """Gets the max_consumers of this ManagementJSStreamParam.

        MaxConsumers is the max number of consumers allowed on the stream

        :return: The max_consumers of this ManagementJSStreamParam.
        :rtype: int
        """
        return self._max_consumers

    @max_consumers.setter
    def max_consumers(self, max_consumers):
        """Sets the max_consumers of this ManagementJSStreamParam.

        MaxConsumers is the max number of consumers allowed on the stream

        :param max_consumers: The max_consumers of this ManagementJSStreamParam.
        :type max_consumers: int
        """
        if max_consumers is not None and max_consumers < -1:
            raise ValueError(
                "Invalid value for `max_consumers`, must be a value greater than or equal to `-1`"
            )

        self._max_consumers = max_consumers

    @property
    def max_msg_size(self):
        """Gets the max_msg_size of this ManagementJSStreamParam.

        MaxMsgSize is the max size of a message allowed in this stream

        :return: The max_msg_size of this ManagementJSStreamParam.
        :rtype: int
        """
        return self._max_msg_size

    @max_msg_size.setter
    def max_msg_size(self, max_msg_size):
        """Sets the max_msg_size of this ManagementJSStreamParam.

        MaxMsgSize is the max size of a message allowed in this stream

        :param max_msg_size: The max_msg_size of this ManagementJSStreamParam.
        :type max_msg_size: int
        """
        if max_msg_size is not None and max_msg_size < -1:
            raise ValueError(
                "Invalid value for `max_msg_size`, must be a value greater than or equal to `-1`"
            )

        self._max_msg_size = max_msg_size

    @property
    def max_msgs(self):
        """Gets the max_msgs of this ManagementJSStreamParam.

        MaxMsgs is the max number of messages the stream will store.  Oldest messages are removed once limit breached.

        :return: The max_msgs of this ManagementJSStreamParam.
        :rtype: int
        """
        return self._max_msgs

    @max_msgs.setter
    def max_msgs(self, max_msgs):
        """Sets the max_msgs of this ManagementJSStreamParam.

        MaxMsgs is the max number of messages the stream will store.  Oldest messages are removed once limit breached.

        :param max_msgs: The max_msgs of this ManagementJSStreamParam.
        :type max_msgs: int
        """
        if max_msgs is not None and max_msgs < -1:
            raise ValueError(
                "Invalid value for `max_msgs`, must be a value greater than or equal to `-1`"
            )

        self._max_msgs = max_msgs

    @property
    def max_msgs_per_subject(self):
        """Gets the max_msgs_per_subject of this ManagementJSStreamParam.

        MaxMsgsPerSubject is the maximum number of subjects allowed on this stream

        :return: The max_msgs_per_subject of this ManagementJSStreamParam.
        :rtype: int
        """
        return self._max_msgs_per_subject

    @max_msgs_per_subject.setter
    def max_msgs_per_subject(self, max_msgs_per_subject):
        """Sets the max_msgs_per_subject of this ManagementJSStreamParam.

        MaxMsgsPerSubject is the maximum number of subjects allowed on this stream

        :param max_msgs_per_subject: The max_msgs_per_subject of this ManagementJSStreamParam.
        :type max_msgs_per_subject: int
        """
        if max_msgs_per_subject is not None and max_msgs_per_subject < -1:
            raise ValueError(
                "Invalid value for `max_msgs_per_subject`, must be a value greater than or equal to `-1`"
            )

        self._max_msgs_per_subject = max_msgs_per_subject

    @property
    def name(self):
        """Gets the name of this ManagementJSStreamParam.

        Name is the stream name

        :return: The name of this ManagementJSStreamParam.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ManagementJSStreamParam.

        Name is the stream name

        :param name: The name of this ManagementJSStreamParam.
        :type name: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def subjects(self):
        """Gets the subjects of this ManagementJSStreamParam.

        Subjects is the list of subjects of interest for this stream

        :return: The subjects of this ManagementJSStreamParam.
        :rtype: List[str]
        """
        return self._subjects

    @subjects.setter
    def subjects(self, subjects):
        """Sets the subjects of this ManagementJSStreamParam.

        Subjects is the list of subjects of interest for this stream

        :param subjects: The subjects of this ManagementJSStreamParam.
        :type subjects: List[str]
        """

        self._subjects = subjects
