# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq import util


class ManagementJSStreamLimits(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(
        self,
        max_age: int = None,
        max_bytes: int = None,
        max_consumers: int = None,
        max_msg_size: int = None,
        max_msgs: int = None,
        max_msgs_per_subject: int = None,
    ):
        """ManagementJSStreamLimits - a model defined in OpenAPI

        :param max_age: The max_age of this ManagementJSStreamLimits.
        :param max_bytes: The max_bytes of this ManagementJSStreamLimits.
        :param max_consumers: The max_consumers of this ManagementJSStreamLimits.
        :param max_msg_size: The max_msg_size of this ManagementJSStreamLimits.
        :param max_msgs: The max_msgs of this ManagementJSStreamLimits.
        :param max_msgs_per_subject: The max_msgs_per_subject of this ManagementJSStreamLimits.
        """
        self.openapi_types = {
            "max_age": int,
            "max_bytes": int,
            "max_consumers": int,
            "max_msg_size": int,
            "max_msgs": int,
            "max_msgs_per_subject": int,
        }

        self.attribute_map = {
            "max_age": "max_age",
            "max_bytes": "max_bytes",
            "max_consumers": "max_consumers",
            "max_msg_size": "max_msg_size",
            "max_msgs": "max_msgs",
            "max_msgs_per_subject": "max_msgs_per_subject",
        }

        self._max_age = max_age
        self._max_bytes = max_bytes
        self._max_consumers = max_consumers
        self._max_msg_size = max_msg_size
        self._max_msgs = max_msgs
        self._max_msgs_per_subject = max_msgs_per_subject

    @classmethod
    def from_dict(cls, dikt: dict) -> "ManagementJSStreamLimits":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The management.JSStreamLimits of this ManagementJSStreamLimits.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def max_age(self):
        """Gets the max_age of this ManagementJSStreamLimits.

        MaxAge is the max duration (ns) the stream will store a message  Messages breaching the limit will be removed.

        :return: The max_age of this ManagementJSStreamLimits.
        :rtype: int
        """
        return self._max_age

    @max_age.setter
    def max_age(self, max_age):
        """Sets the max_age of this ManagementJSStreamLimits.

        MaxAge is the max duration (ns) the stream will store a message  Messages breaching the limit will be removed.

        :param max_age: The max_age of this ManagementJSStreamLimits.
        :type max_age: int
        """

        self._max_age = max_age

    @property
    def max_bytes(self):
        """Gets the max_bytes of this ManagementJSStreamLimits.

        MaxBytes is the max number of message bytes the stream will store.  Oldest messages are removed once limit breached.

        :return: The max_bytes of this ManagementJSStreamLimits.
        :rtype: int
        """
        return self._max_bytes

    @max_bytes.setter
    def max_bytes(self, max_bytes):
        """Sets the max_bytes of this ManagementJSStreamLimits.

        MaxBytes is the max number of message bytes the stream will store.  Oldest messages are removed once limit breached.

        :param max_bytes: The max_bytes of this ManagementJSStreamLimits.
        :type max_bytes: int
        """
        if max_bytes is not None and max_bytes < -1:
            raise ValueError(
                "Invalid value for `max_bytes`, must be a value greater than or equal to `-1`"
            )

        self._max_bytes = max_bytes

    @property
    def max_consumers(self):
        """Gets the max_consumers of this ManagementJSStreamLimits.

        MaxConsumers is the max number of consumers allowed on the stream

        :return: The max_consumers of this ManagementJSStreamLimits.
        :rtype: int
        """
        return self._max_consumers

    @max_consumers.setter
    def max_consumers(self, max_consumers):
        """Sets the max_consumers of this ManagementJSStreamLimits.

        MaxConsumers is the max number of consumers allowed on the stream

        :param max_consumers: The max_consumers of this ManagementJSStreamLimits.
        :type max_consumers: int
        """
        if max_consumers is not None and max_consumers < -1:
            raise ValueError(
                "Invalid value for `max_consumers`, must be a value greater than or equal to `-1`"
            )

        self._max_consumers = max_consumers

    @property
    def max_msg_size(self):
        """Gets the max_msg_size of this ManagementJSStreamLimits.

        MaxMsgSize is the max size of a message allowed in this stream

        :return: The max_msg_size of this ManagementJSStreamLimits.
        :rtype: int
        """
        return self._max_msg_size

    @max_msg_size.setter
    def max_msg_size(self, max_msg_size):
        """Sets the max_msg_size of this ManagementJSStreamLimits.

        MaxMsgSize is the max size of a message allowed in this stream

        :param max_msg_size: The max_msg_size of this ManagementJSStreamLimits.
        :type max_msg_size: int
        """
        if max_msg_size is not None and max_msg_size < -1:
            raise ValueError(
                "Invalid value for `max_msg_size`, must be a value greater than or equal to `-1`"
            )

        self._max_msg_size = max_msg_size

    @property
    def max_msgs(self):
        """Gets the max_msgs of this ManagementJSStreamLimits.

        MaxMsgs is the max number of messages the stream will store.  Oldest messages are removed once limit breached.

        :return: The max_msgs of this ManagementJSStreamLimits.
        :rtype: int
        """
        return self._max_msgs

    @max_msgs.setter
    def max_msgs(self, max_msgs):
        """Sets the max_msgs of this ManagementJSStreamLimits.

        MaxMsgs is the max number of messages the stream will store.  Oldest messages are removed once limit breached.

        :param max_msgs: The max_msgs of this ManagementJSStreamLimits.
        :type max_msgs: int
        """
        if max_msgs is not None and max_msgs < -1:
            raise ValueError(
                "Invalid value for `max_msgs`, must be a value greater than or equal to `-1`"
            )

        self._max_msgs = max_msgs

    @property
    def max_msgs_per_subject(self):
        """Gets the max_msgs_per_subject of this ManagementJSStreamLimits.

        MaxMsgsPerSubject is the maximum number of subjects allowed on this stream

        :return: The max_msgs_per_subject of this ManagementJSStreamLimits.
        :rtype: int
        """
        return self._max_msgs_per_subject

    @max_msgs_per_subject.setter
    def max_msgs_per_subject(self, max_msgs_per_subject):
        """Sets the max_msgs_per_subject of this ManagementJSStreamLimits.

        MaxMsgsPerSubject is the maximum number of subjects allowed on this stream

        :param max_msgs_per_subject: The max_msgs_per_subject of this ManagementJSStreamLimits.
        :type max_msgs_per_subject: int
        """
        if max_msgs_per_subject is not None and max_msgs_per_subject < -1:
            raise ValueError(
                "Invalid value for `max_msgs_per_subject`, must be a value greater than or equal to `-1`"
            )

        self._max_msgs_per_subject = max_msgs_per_subject
