# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq import util


class ManagementJetStreamConsumerParam(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(
        self,
        ack_wait: int = None,
        delivery_group: str = None,
        filter_subject: str = None,
        max_inflight: int = None,
        max_retry: int = None,
        mode: str = None,
        name: str = None,
        notes: str = None,
    ):
        """ManagementJetStreamConsumerParam - a model defined in OpenAPI

        :param ack_wait: The ack_wait of this ManagementJetStreamConsumerParam.
        :param delivery_group: The delivery_group of this ManagementJetStreamConsumerParam.
        :param filter_subject: The filter_subject of this ManagementJetStreamConsumerParam.
        :param max_inflight: The max_inflight of this ManagementJetStreamConsumerParam.
        :param max_retry: The max_retry of this ManagementJetStreamConsumerParam.
        :param mode: The mode of this ManagementJetStreamConsumerParam.
        :param name: The name of this ManagementJetStreamConsumerParam.
        :param notes: The notes of this ManagementJetStreamConsumerParam.
        """
        self.openapi_types = {
            "ack_wait": int,
            "delivery_group": str,
            "filter_subject": str,
            "max_inflight": int,
            "max_retry": int,
            "mode": str,
            "name": str,
            "notes": str,
        }

        self.attribute_map = {
            "ack_wait": "ack_wait",
            "delivery_group": "delivery_group",
            "filter_subject": "filter_subject",
            "max_inflight": "max_inflight",
            "max_retry": "max_retry",
            "mode": "mode",
            "name": "name",
            "notes": "notes",
        }

        self._ack_wait = ack_wait
        self._delivery_group = delivery_group
        self._filter_subject = filter_subject
        self._max_inflight = max_inflight
        self._max_retry = max_retry
        self._mode = mode
        self._name = name
        self._notes = notes

    @classmethod
    def from_dict(cls, dikt: dict) -> "ManagementJetStreamConsumerParam":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The management.JetStreamConsumerParam of this ManagementJetStreamConsumerParam.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def ack_wait(self):
        """Gets the ack_wait of this ManagementJetStreamConsumerParam.

        AckWait when specified, the number of ns to wait for ACK before retry

        :return: The ack_wait of this ManagementJetStreamConsumerParam.
        :rtype: int
        """
        return self._ack_wait

    @ack_wait.setter
    def ack_wait(self, ack_wait):
        """Sets the ack_wait of this ManagementJetStreamConsumerParam.

        AckWait when specified, the number of ns to wait for ACK before retry

        :param ack_wait: The ack_wait of this ManagementJetStreamConsumerParam.
        :type ack_wait: int
        """

        self._ack_wait = ack_wait

    @property
    def delivery_group(self):
        """Gets the delivery_group of this ManagementJetStreamConsumerParam.

        DeliveryGroup creates a consumer using a delivery group name.  A consumer using delivery group allows multiple clients to subscribe under the same consumer and group name tuple. For subjects this consumer listens to, the messages will be shared amongst the connected clients.

        :return: The delivery_group of this ManagementJetStreamConsumerParam.
        :rtype: str
        """
        return self._delivery_group

    @delivery_group.setter
    def delivery_group(self, delivery_group):
        """Sets the delivery_group of this ManagementJetStreamConsumerParam.

        DeliveryGroup creates a consumer using a delivery group name.  A consumer using delivery group allows multiple clients to subscribe under the same consumer and group name tuple. For subjects this consumer listens to, the messages will be shared amongst the connected clients.

        :param delivery_group: The delivery_group of this ManagementJetStreamConsumerParam.
        :type delivery_group: str
        """

        self._delivery_group = delivery_group

    @property
    def filter_subject(self):
        """Gets the filter_subject of this ManagementJetStreamConsumerParam.

        FilterSubject sets the consumer to filter for subjects matching this NATs subject string  See https://docs.nats.io/nats-concepts/subjects

        :return: The filter_subject of this ManagementJetStreamConsumerParam.
        :rtype: str
        """
        return self._filter_subject

    @filter_subject.setter
    def filter_subject(self, filter_subject):
        """Sets the filter_subject of this ManagementJetStreamConsumerParam.

        FilterSubject sets the consumer to filter for subjects matching this NATs subject string  See https://docs.nats.io/nats-concepts/subjects

        :param filter_subject: The filter_subject of this ManagementJetStreamConsumerParam.
        :type filter_subject: str
        """

        self._filter_subject = filter_subject

    @property
    def max_inflight(self):
        """Gets the max_inflight of this ManagementJetStreamConsumerParam.

        MaxInflight is max number of un-ACKed message permitted in-flight (must be >= 1)

        :return: The max_inflight of this ManagementJetStreamConsumerParam.
        :rtype: int
        """
        return self._max_inflight

    @max_inflight.setter
    def max_inflight(self, max_inflight):
        """Sets the max_inflight of this ManagementJetStreamConsumerParam.

        MaxInflight is max number of un-ACKed message permitted in-flight (must be >= 1)

        :param max_inflight: The max_inflight of this ManagementJetStreamConsumerParam.
        :type max_inflight: int
        """
        if max_inflight is None:
            raise ValueError("Invalid value for `max_inflight`, must not be `None`")
        if max_inflight is not None and max_inflight < 1:
            raise ValueError(
                "Invalid value for `max_inflight`, must be a value greater than or equal to `1`"
            )

        self._max_inflight = max_inflight

    @property
    def max_retry(self):
        """Gets the max_retry of this ManagementJetStreamConsumerParam.

        MaxRetry max number of times an un-ACKed message is resent (-1: infinite)

        :return: The max_retry of this ManagementJetStreamConsumerParam.
        :rtype: int
        """
        return self._max_retry

    @max_retry.setter
    def max_retry(self, max_retry):
        """Sets the max_retry of this ManagementJetStreamConsumerParam.

        MaxRetry max number of times an un-ACKed message is resent (-1: infinite)

        :param max_retry: The max_retry of this ManagementJetStreamConsumerParam.
        :type max_retry: int
        """
        if max_retry is not None and max_retry < -1:
            raise ValueError(
                "Invalid value for `max_retry`, must be a value greater than or equal to `-1`"
            )

        self._max_retry = max_retry

    @property
    def mode(self):
        """Gets the mode of this ManagementJetStreamConsumerParam.

        Mode whether the consumer is push or pull consumer

        :return: The mode of this ManagementJetStreamConsumerParam.
        :rtype: str
        """
        return self._mode

    @mode.setter
    def mode(self, mode):
        """Sets the mode of this ManagementJetStreamConsumerParam.

        Mode whether the consumer is push or pull consumer

        :param mode: The mode of this ManagementJetStreamConsumerParam.
        :type mode: str
        """
        allowed_values = ["push", "pull"]  # noqa: E501
        if mode not in allowed_values:
            raise ValueError(
                "Invalid value for `mode` ({0}), must be one of {1}".format(
                    mode, allowed_values
                )
            )

        self._mode = mode

    @property
    def name(self):
        """Gets the name of this ManagementJetStreamConsumerParam.

        Name is the consumer name

        :return: The name of this ManagementJetStreamConsumerParam.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ManagementJetStreamConsumerParam.

        Name is the consumer name

        :param name: The name of this ManagementJetStreamConsumerParam.
        :type name: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def notes(self):
        """Gets the notes of this ManagementJetStreamConsumerParam.

        Notes are descriptions regarding this consumer

        :return: The notes of this ManagementJetStreamConsumerParam.
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """Sets the notes of this ManagementJetStreamConsumerParam.

        Notes are descriptions regarding this consumer

        :param notes: The notes of this ManagementJetStreamConsumerParam.
        :type notes: str
        """

        self._notes = notes
