# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq.models.goutils_error_detail import GoutilsErrorDetail
from httpmq import util


class GoutilsRestAPIBaseResponse(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(
        self,
        error: GoutilsErrorDetail = None,
        request_id: str = None,
        success: bool = None,
    ):
        """GoutilsRestAPIBaseResponse - a model defined in OpenAPI

        :param error: The error of this GoutilsRestAPIBaseResponse.
        :param request_id: The request_id of this GoutilsRestAPIBaseResponse.
        :param success: The success of this GoutilsRestAPIBaseResponse.
        """
        self.openapi_types = {
            "error": GoutilsErrorDetail,
            "request_id": str,
            "success": bool,
        }

        self.attribute_map = {
            "error": "error",
            "request_id": "request_id",
            "success": "success",
        }

        self._error = error
        self._request_id = request_id
        self._success = success

    @classmethod
    def from_dict(cls, dikt: dict) -> "GoutilsRestAPIBaseResponse":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The goutils.RestAPIBaseResponse of this GoutilsRestAPIBaseResponse.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def error(self):
        """Gets the error of this GoutilsRestAPIBaseResponse.


        :return: The error of this GoutilsRestAPIBaseResponse.
        :rtype: GoutilsErrorDetail
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this GoutilsRestAPIBaseResponse.


        :param error: The error of this GoutilsRestAPIBaseResponse.
        :type error: GoutilsErrorDetail
        """

        self._error = error

    @property
    def request_id(self):
        """Gets the request_id of this GoutilsRestAPIBaseResponse.

        RequestID gives the request ID to match against logs

        :return: The request_id of this GoutilsRestAPIBaseResponse.
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        """Sets the request_id of this GoutilsRestAPIBaseResponse.

        RequestID gives the request ID to match against logs

        :param request_id: The request_id of this GoutilsRestAPIBaseResponse.
        :type request_id: str
        """
        if request_id is None:
            raise ValueError("Invalid value for `request_id`, must not be `None`")

        self._request_id = request_id

    @property
    def success(self):
        """Gets the success of this GoutilsRestAPIBaseResponse.

        Success indicates whether the request was successful

        :return: The success of this GoutilsRestAPIBaseResponse.
        :rtype: bool
        """
        return self._success

    @success.setter
    def success(self, success):
        """Sets the success of this GoutilsRestAPIBaseResponse.

        Success indicates whether the request was successful

        :param success: The success of this GoutilsRestAPIBaseResponse.
        :type success: bool
        """
        if success is None:
            raise ValueError("Invalid value for `success`, must not be `None`")

        self._success = success
