# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq import util


class GoutilsErrorDetail(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, code: int = None, detail: str = None, message: str = None):
        """GoutilsErrorDetail - a model defined in OpenAPI

        :param code: The code of this GoutilsErrorDetail.
        :param detail: The detail of this GoutilsErrorDetail.
        :param message: The message of this GoutilsErrorDetail.
        """
        self.openapi_types = {"code": int, "detail": str, "message": str}

        self.attribute_map = {"code": "code", "detail": "detail", "message": "message"}

        self._code = code
        self._detail = detail
        self._message = message

    @classmethod
    def from_dict(cls, dikt: dict) -> "GoutilsErrorDetail":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The goutils.ErrorDetail of this GoutilsErrorDetail.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def code(self):
        """Gets the code of this GoutilsErrorDetail.

        Code is the response code

        :return: The code of this GoutilsErrorDetail.
        :rtype: int
        """
        return self._code

    @code.setter
    def code(self, code):
        """Sets the code of this GoutilsErrorDetail.

        Code is the response code

        :param code: The code of this GoutilsErrorDetail.
        :type code: int
        """
        if code is None:
            raise ValueError("Invalid value for `code`, must not be `None`")

        self._code = code

    @property
    def detail(self):
        """Gets the detail of this GoutilsErrorDetail.

        Detail is an optional descriptive message providing additional details on the error

        :return: The detail of this GoutilsErrorDetail.
        :rtype: str
        """
        return self._detail

    @detail.setter
    def detail(self, detail):
        """Sets the detail of this GoutilsErrorDetail.

        Detail is an optional descriptive message providing additional details on the error

        :param detail: The detail of this GoutilsErrorDetail.
        :type detail: str
        """

        self._detail = detail

    @property
    def message(self):
        """Gets the message of this GoutilsErrorDetail.

        Msg is an optional descriptive message

        :return: The message of this GoutilsErrorDetail.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this GoutilsErrorDetail.

        Msg is an optional descriptive message

        :param message: The message of this GoutilsErrorDetail.
        :type message: str
        """

        self._message = message
