# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq import util


class DataplaneMsgToDeliverSeq(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, consumer: int = None, stream: int = None):
        """DataplaneMsgToDeliverSeq - a model defined in OpenAPI

        :param consumer: The consumer of this DataplaneMsgToDeliverSeq.
        :param stream: The stream of this DataplaneMsgToDeliverSeq.
        """
        self.openapi_types = {"consumer": int, "stream": int}

        self.attribute_map = {"consumer": "consumer", "stream": "stream"}

        self._consumer = consumer
        self._stream = stream

    @classmethod
    def from_dict(cls, dikt: dict) -> "DataplaneMsgToDeliverSeq":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The dataplane.MsgToDeliverSeq of this DataplaneMsgToDeliverSeq.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def consumer(self):
        """Gets the consumer of this DataplaneMsgToDeliverSeq.

        Consumer is the message sequence number for this consumer

        :return: The consumer of this DataplaneMsgToDeliverSeq.
        :rtype: int
        """
        return self._consumer

    @consumer.setter
    def consumer(self, consumer):
        """Sets the consumer of this DataplaneMsgToDeliverSeq.

        Consumer is the message sequence number for this consumer

        :param consumer: The consumer of this DataplaneMsgToDeliverSeq.
        :type consumer: int
        """
        if consumer is None:
            raise ValueError("Invalid value for `consumer`, must not be `None`")
        if consumer is not None and consumer < 0:
            raise ValueError(
                "Invalid value for `consumer`, must be a value greater than or equal to `0`"
            )

        self._consumer = consumer

    @property
    def stream(self):
        """Gets the stream of this DataplaneMsgToDeliverSeq.

        Stream is the message sequence number within the stream

        :return: The stream of this DataplaneMsgToDeliverSeq.
        :rtype: int
        """
        return self._stream

    @stream.setter
    def stream(self, stream):
        """Sets the stream of this DataplaneMsgToDeliverSeq.

        Stream is the message sequence number within the stream

        :param stream: The stream of this DataplaneMsgToDeliverSeq.
        :type stream: int
        """
        if stream is None:
            raise ValueError("Invalid value for `stream`, must not be `None`")
        if stream is not None and stream < 0:
            raise ValueError(
                "Invalid value for `stream`, must be a value greater than or equal to `0`"
            )

        self._stream = stream
