# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq import util


class DataplaneAckSeqNum(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, consumer: int = None, stream: int = None):
        """DataplaneAckSeqNum - a model defined in OpenAPI

        :param consumer: The consumer of this DataplaneAckSeqNum.
        :param stream: The stream of this DataplaneAckSeqNum.
        """
        self.openapi_types = {"consumer": int, "stream": int}

        self.attribute_map = {"consumer": "consumer", "stream": "stream"}

        self._consumer = consumer
        self._stream = stream

    @classmethod
    def from_dict(cls, dikt: dict) -> "DataplaneAckSeqNum":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The dataplane.AckSeqNum of this DataplaneAckSeqNum.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def consumer(self):
        """Gets the consumer of this DataplaneAckSeqNum.

        Consumer is the JetStream message sequence number for this consumer

        :return: The consumer of this DataplaneAckSeqNum.
        :rtype: int
        """
        return self._consumer

    @consumer.setter
    def consumer(self, consumer):
        """Sets the consumer of this DataplaneAckSeqNum.

        Consumer is the JetStream message sequence number for this consumer

        :param consumer: The consumer of this DataplaneAckSeqNum.
        :type consumer: int
        """
        if consumer is None:
            raise ValueError("Invalid value for `consumer`, must not be `None`")
        if consumer is not None and consumer < 0:
            raise ValueError(
                "Invalid value for `consumer`, must be a value greater than or equal to `0`"
            )

        self._consumer = consumer

    @property
    def stream(self):
        """Gets the stream of this DataplaneAckSeqNum.

        Stream is the JetStream message sequence number for this stream

        :return: The stream of this DataplaneAckSeqNum.
        :rtype: int
        """
        return self._stream

    @stream.setter
    def stream(self, stream):
        """Sets the stream of this DataplaneAckSeqNum.

        Stream is the JetStream message sequence number for this stream

        :param stream: The stream of this DataplaneAckSeqNum.
        :type stream: int
        """
        if stream is None:
            raise ValueError("Invalid value for `stream`, must not be `None`")
        if stream is not None and stream < 0:
            raise ValueError(
                "Invalid value for `stream`, must be a value greater than or equal to `0`"
            )

        self._stream = stream
