# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq import util


class ApisAPIRestRespStreamState(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(
        self,
        bytes: int = None,
        consumer_count: int = None,
        first_seq: int = None,
        first_ts: str = None,
        last_seq: int = None,
        last_ts: str = None,
        messages: int = None,
    ):
        """ApisAPIRestRespStreamState - a model defined in OpenAPI

        :param bytes: The bytes of this ApisAPIRestRespStreamState.
        :param consumer_count: The consumer_count of this ApisAPIRestRespStreamState.
        :param first_seq: The first_seq of this ApisAPIRestRespStreamState.
        :param first_ts: The first_ts of this ApisAPIRestRespStreamState.
        :param last_seq: The last_seq of this ApisAPIRestRespStreamState.
        :param last_ts: The last_ts of this ApisAPIRestRespStreamState.
        :param messages: The messages of this ApisAPIRestRespStreamState.
        """
        self.openapi_types = {
            "bytes": int,
            "consumer_count": int,
            "first_seq": int,
            "first_ts": str,
            "last_seq": int,
            "last_ts": str,
            "messages": int,
        }

        self.attribute_map = {
            "bytes": "bytes",
            "consumer_count": "consumer_count",
            "first_seq": "first_seq",
            "first_ts": "first_ts",
            "last_seq": "last_seq",
            "last_ts": "last_ts",
            "messages": "messages",
        }

        self._bytes = bytes
        self._consumer_count = consumer_count
        self._first_seq = first_seq
        self._first_ts = first_ts
        self._last_seq = last_seq
        self._last_ts = last_ts
        self._messages = messages

    @classmethod
    def from_dict(cls, dikt: dict) -> "ApisAPIRestRespStreamState":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The apis.APIRestRespStreamState of this ApisAPIRestRespStreamState.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def bytes(self):
        """Gets the bytes of this ApisAPIRestRespStreamState.

        Bytes is the number of message bytes in the stream

        :return: The bytes of this ApisAPIRestRespStreamState.
        :rtype: int
        """
        return self._bytes

    @bytes.setter
    def bytes(self, bytes):
        """Sets the bytes of this ApisAPIRestRespStreamState.

        Bytes is the number of message bytes in the stream

        :param bytes: The bytes of this ApisAPIRestRespStreamState.
        :type bytes: int
        """
        if bytes is None:
            raise ValueError("Invalid value for `bytes`, must not be `None`")

        self._bytes = bytes

    @property
    def consumer_count(self):
        """Gets the consumer_count of this ApisAPIRestRespStreamState.

        Consumers number of consumers on the stream

        :return: The consumer_count of this ApisAPIRestRespStreamState.
        :rtype: int
        """
        return self._consumer_count

    @consumer_count.setter
    def consumer_count(self, consumer_count):
        """Sets the consumer_count of this ApisAPIRestRespStreamState.

        Consumers number of consumers on the stream

        :param consumer_count: The consumer_count of this ApisAPIRestRespStreamState.
        :type consumer_count: int
        """
        if consumer_count is None:
            raise ValueError("Invalid value for `consumer_count`, must not be `None`")

        self._consumer_count = consumer_count

    @property
    def first_seq(self):
        """Gets the first_seq of this ApisAPIRestRespStreamState.

        FirstSeq is the oldest message sequence number on the stream

        :return: The first_seq of this ApisAPIRestRespStreamState.
        :rtype: int
        """
        return self._first_seq

    @first_seq.setter
    def first_seq(self, first_seq):
        """Sets the first_seq of this ApisAPIRestRespStreamState.

        FirstSeq is the oldest message sequence number on the stream

        :param first_seq: The first_seq of this ApisAPIRestRespStreamState.
        :type first_seq: int
        """
        if first_seq is None:
            raise ValueError("Invalid value for `first_seq`, must not be `None`")

        self._first_seq = first_seq

    @property
    def first_ts(self):
        """Gets the first_ts of this ApisAPIRestRespStreamState.

        FirstTime is the oldest message timestamp on the stream

        :return: The first_ts of this ApisAPIRestRespStreamState.
        :rtype: str
        """
        return self._first_ts

    @first_ts.setter
    def first_ts(self, first_ts):
        """Sets the first_ts of this ApisAPIRestRespStreamState.

        FirstTime is the oldest message timestamp on the stream

        :param first_ts: The first_ts of this ApisAPIRestRespStreamState.
        :type first_ts: str
        """
        if first_ts is None:
            raise ValueError("Invalid value for `first_ts`, must not be `None`")

        self._first_ts = first_ts

    @property
    def last_seq(self):
        """Gets the last_seq of this ApisAPIRestRespStreamState.

        LastSeq is the newest message sequence number on the stream

        :return: The last_seq of this ApisAPIRestRespStreamState.
        :rtype: int
        """
        return self._last_seq

    @last_seq.setter
    def last_seq(self, last_seq):
        """Sets the last_seq of this ApisAPIRestRespStreamState.

        LastSeq is the newest message sequence number on the stream

        :param last_seq: The last_seq of this ApisAPIRestRespStreamState.
        :type last_seq: int
        """
        if last_seq is None:
            raise ValueError("Invalid value for `last_seq`, must not be `None`")

        self._last_seq = last_seq

    @property
    def last_ts(self):
        """Gets the last_ts of this ApisAPIRestRespStreamState.

        LastTime is the newest message timestamp on the stream

        :return: The last_ts of this ApisAPIRestRespStreamState.
        :rtype: str
        """
        return self._last_ts

    @last_ts.setter
    def last_ts(self, last_ts):
        """Sets the last_ts of this ApisAPIRestRespStreamState.

        LastTime is the newest message timestamp on the stream

        :param last_ts: The last_ts of this ApisAPIRestRespStreamState.
        :type last_ts: str
        """
        if last_ts is None:
            raise ValueError("Invalid value for `last_ts`, must not be `None`")

        self._last_ts = last_ts

    @property
    def messages(self):
        """Gets the messages of this ApisAPIRestRespStreamState.

        Msgs is the number of messages in the stream

        :return: The messages of this ApisAPIRestRespStreamState.
        :rtype: int
        """
        return self._messages

    @messages.setter
    def messages(self, messages):
        """Sets the messages of this ApisAPIRestRespStreamState.

        Msgs is the number of messages in the stream

        :param messages: The messages of this ApisAPIRestRespStreamState.
        :type messages: int
        """
        if messages is None:
            raise ValueError("Invalid value for `messages`, must not be `None`")

        self._messages = messages
