# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq.models.apis_api_rest_resp_stream_config import ApisAPIRestRespStreamConfig
from httpmq.models.apis_api_rest_resp_stream_state import ApisAPIRestRespStreamState
from httpmq import util


class ApisAPIRestRespStreamInfo(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(
        self,
        config: ApisAPIRestRespStreamConfig = None,
        created: str = None,
        state: ApisAPIRestRespStreamState = None,
    ):
        """ApisAPIRestRespStreamInfo - a model defined in OpenAPI

        :param config: The config of this ApisAPIRestRespStreamInfo.
        :param created: The created of this ApisAPIRestRespStreamInfo.
        :param state: The state of this ApisAPIRestRespStreamInfo.
        """
        self.openapi_types = {
            "config": ApisAPIRestRespStreamConfig,
            "created": str,
            "state": ApisAPIRestRespStreamState,
        }

        self.attribute_map = {
            "config": "config",
            "created": "created",
            "state": "state",
        }

        self._config = config
        self._created = created
        self._state = state

    @classmethod
    def from_dict(cls, dikt: dict) -> "ApisAPIRestRespStreamInfo":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The apis.APIRestRespStreamInfo of this ApisAPIRestRespStreamInfo.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def config(self):
        """Gets the config of this ApisAPIRestRespStreamInfo.


        :return: The config of this ApisAPIRestRespStreamInfo.
        :rtype: ApisAPIRestRespStreamConfig
        """
        return self._config

    @config.setter
    def config(self, config):
        """Sets the config of this ApisAPIRestRespStreamInfo.


        :param config: The config of this ApisAPIRestRespStreamInfo.
        :type config: ApisAPIRestRespStreamConfig
        """
        if config is None:
            raise ValueError("Invalid value for `config`, must not be `None`")

        self._config = config

    @property
    def created(self):
        """Gets the created of this ApisAPIRestRespStreamInfo.

        Created is the stream creation timestamp

        :return: The created of this ApisAPIRestRespStreamInfo.
        :rtype: str
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this ApisAPIRestRespStreamInfo.

        Created is the stream creation timestamp

        :param created: The created of this ApisAPIRestRespStreamInfo.
        :type created: str
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")

        self._created = created

    @property
    def state(self):
        """Gets the state of this ApisAPIRestRespStreamInfo.


        :return: The state of this ApisAPIRestRespStreamInfo.
        :rtype: ApisAPIRestRespStreamState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this ApisAPIRestRespStreamInfo.


        :param state: The state of this ApisAPIRestRespStreamInfo.
        :type state: ApisAPIRestRespStreamState
        """
        if state is None:
            raise ValueError("Invalid value for `state`, must not be `None`")

        self._state = state
