# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq import util


class ApisAPIRestRespStreamConfig(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(
        self,
        description: str = None,
        max_age: int = None,
        max_bytes: int = None,
        max_consumers: int = None,
        max_msg_size: int = None,
        max_msgs: int = None,
        max_msgs_per_subject: int = None,
        name: str = None,
        subjects: List[str] = None,
    ):
        """ApisAPIRestRespStreamConfig - a model defined in OpenAPI

        :param description: The description of this ApisAPIRestRespStreamConfig.
        :param max_age: The max_age of this ApisAPIRestRespStreamConfig.
        :param max_bytes: The max_bytes of this ApisAPIRestRespStreamConfig.
        :param max_consumers: The max_consumers of this ApisAPIRestRespStreamConfig.
        :param max_msg_size: The max_msg_size of this ApisAPIRestRespStreamConfig.
        :param max_msgs: The max_msgs of this ApisAPIRestRespStreamConfig.
        :param max_msgs_per_subject: The max_msgs_per_subject of this ApisAPIRestRespStreamConfig.
        :param name: The name of this ApisAPIRestRespStreamConfig.
        :param subjects: The subjects of this ApisAPIRestRespStreamConfig.
        """
        self.openapi_types = {
            "description": str,
            "max_age": int,
            "max_bytes": int,
            "max_consumers": int,
            "max_msg_size": int,
            "max_msgs": int,
            "max_msgs_per_subject": int,
            "name": str,
            "subjects": List[str],
        }

        self.attribute_map = {
            "description": "description",
            "max_age": "max_age",
            "max_bytes": "max_bytes",
            "max_consumers": "max_consumers",
            "max_msg_size": "max_msg_size",
            "max_msgs": "max_msgs",
            "max_msgs_per_subject": "max_msgs_per_subject",
            "name": "name",
            "subjects": "subjects",
        }

        self._description = description
        self._max_age = max_age
        self._max_bytes = max_bytes
        self._max_consumers = max_consumers
        self._max_msg_size = max_msg_size
        self._max_msgs = max_msgs
        self._max_msgs_per_subject = max_msgs_per_subject
        self._name = name
        self._subjects = subjects

    @classmethod
    def from_dict(cls, dikt: dict) -> "ApisAPIRestRespStreamConfig":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The apis.APIRestRespStreamConfig of this ApisAPIRestRespStreamConfig.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def description(self):
        """Gets the description of this ApisAPIRestRespStreamConfig.

        Description is an optional description of the stream

        :return: The description of this ApisAPIRestRespStreamConfig.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ApisAPIRestRespStreamConfig.

        Description is an optional description of the stream

        :param description: The description of this ApisAPIRestRespStreamConfig.
        :type description: str
        """

        self._description = description

    @property
    def max_age(self):
        """Gets the max_age of this ApisAPIRestRespStreamConfig.

        MaxBytes is the max duration (ns) the stream will store a message  Messages breaching the limit will be removed.

        :return: The max_age of this ApisAPIRestRespStreamConfig.
        :rtype: int
        """
        return self._max_age

    @max_age.setter
    def max_age(self, max_age):
        """Sets the max_age of this ApisAPIRestRespStreamConfig.

        MaxBytes is the max duration (ns) the stream will store a message  Messages breaching the limit will be removed.

        :param max_age: The max_age of this ApisAPIRestRespStreamConfig.
        :type max_age: int
        """
        if max_age is None:
            raise ValueError("Invalid value for `max_age`, must not be `None`")

        self._max_age = max_age

    @property
    def max_bytes(self):
        """Gets the max_bytes of this ApisAPIRestRespStreamConfig.

        MaxBytes is the max number of message bytes the stream will store.  Oldest messages are removed once limit breached.

        :return: The max_bytes of this ApisAPIRestRespStreamConfig.
        :rtype: int
        """
        return self._max_bytes

    @max_bytes.setter
    def max_bytes(self, max_bytes):
        """Sets the max_bytes of this ApisAPIRestRespStreamConfig.

        MaxBytes is the max number of message bytes the stream will store.  Oldest messages are removed once limit breached.

        :param max_bytes: The max_bytes of this ApisAPIRestRespStreamConfig.
        :type max_bytes: int
        """
        if max_bytes is None:
            raise ValueError("Invalid value for `max_bytes`, must not be `None`")

        self._max_bytes = max_bytes

    @property
    def max_consumers(self):
        """Gets the max_consumers of this ApisAPIRestRespStreamConfig.

        MaxConsumers is the max number of consumers allowed on the stream

        :return: The max_consumers of this ApisAPIRestRespStreamConfig.
        :rtype: int
        """
        return self._max_consumers

    @max_consumers.setter
    def max_consumers(self, max_consumers):
        """Sets the max_consumers of this ApisAPIRestRespStreamConfig.

        MaxConsumers is the max number of consumers allowed on the stream

        :param max_consumers: The max_consumers of this ApisAPIRestRespStreamConfig.
        :type max_consumers: int
        """
        if max_consumers is None:
            raise ValueError("Invalid value for `max_consumers`, must not be `None`")

        self._max_consumers = max_consumers

    @property
    def max_msg_size(self):
        """Gets the max_msg_size of this ApisAPIRestRespStreamConfig.

        MaxMsgSize is the max size of a message allowed in this stream

        :return: The max_msg_size of this ApisAPIRestRespStreamConfig.
        :rtype: int
        """
        return self._max_msg_size

    @max_msg_size.setter
    def max_msg_size(self, max_msg_size):
        """Sets the max_msg_size of this ApisAPIRestRespStreamConfig.

        MaxMsgSize is the max size of a message allowed in this stream

        :param max_msg_size: The max_msg_size of this ApisAPIRestRespStreamConfig.
        :type max_msg_size: int
        """

        self._max_msg_size = max_msg_size

    @property
    def max_msgs(self):
        """Gets the max_msgs of this ApisAPIRestRespStreamConfig.

        MaxMsgs is the max number of messages the stream will store.  Oldest messages are removed once limit breached.

        :return: The max_msgs of this ApisAPIRestRespStreamConfig.
        :rtype: int
        """
        return self._max_msgs

    @max_msgs.setter
    def max_msgs(self, max_msgs):
        """Sets the max_msgs of this ApisAPIRestRespStreamConfig.

        MaxMsgs is the max number of messages the stream will store.  Oldest messages are removed once limit breached.

        :param max_msgs: The max_msgs of this ApisAPIRestRespStreamConfig.
        :type max_msgs: int
        """
        if max_msgs is None:
            raise ValueError("Invalid value for `max_msgs`, must not be `None`")

        self._max_msgs = max_msgs

    @property
    def max_msgs_per_subject(self):
        """Gets the max_msgs_per_subject of this ApisAPIRestRespStreamConfig.

        MaxMsgsPerSubject is the maximum number of subjects allowed on this stream

        :return: The max_msgs_per_subject of this ApisAPIRestRespStreamConfig.
        :rtype: int
        """
        return self._max_msgs_per_subject

    @max_msgs_per_subject.setter
    def max_msgs_per_subject(self, max_msgs_per_subject):
        """Sets the max_msgs_per_subject of this ApisAPIRestRespStreamConfig.

        MaxMsgsPerSubject is the maximum number of subjects allowed on this stream

        :param max_msgs_per_subject: The max_msgs_per_subject of this ApisAPIRestRespStreamConfig.
        :type max_msgs_per_subject: int
        """
        if max_msgs_per_subject is None:
            raise ValueError(
                "Invalid value for `max_msgs_per_subject`, must not be `None`"
            )

        self._max_msgs_per_subject = max_msgs_per_subject

    @property
    def name(self):
        """Gets the name of this ApisAPIRestRespStreamConfig.

        Name is the stream name

        :return: The name of this ApisAPIRestRespStreamConfig.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ApisAPIRestRespStreamConfig.

        Name is the stream name

        :param name: The name of this ApisAPIRestRespStreamConfig.
        :type name: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def subjects(self):
        """Gets the subjects of this ApisAPIRestRespStreamConfig.

        Subjects is the list subjects this stream is listening on

        :return: The subjects of this ApisAPIRestRespStreamConfig.
        :rtype: List[str]
        """
        return self._subjects

    @subjects.setter
    def subjects(self, subjects):
        """Sets the subjects of this ApisAPIRestRespStreamConfig.

        Subjects is the list subjects this stream is listening on

        :param subjects: The subjects of this ApisAPIRestRespStreamConfig.
        :type subjects: List[str]
        """

        self._subjects = subjects
