# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq import util


class ApisAPIRestRespSequenceInfo(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(
        self, consumer_seq: int = None, last_active: str = None, stream_seq: int = None
    ):
        """ApisAPIRestRespSequenceInfo - a model defined in OpenAPI

        :param consumer_seq: The consumer_seq of this ApisAPIRestRespSequenceInfo.
        :param last_active: The last_active of this ApisAPIRestRespSequenceInfo.
        :param stream_seq: The stream_seq of this ApisAPIRestRespSequenceInfo.
        """
        self.openapi_types = {
            "consumer_seq": int,
            "last_active": str,
            "stream_seq": int,
        }

        self.attribute_map = {
            "consumer_seq": "consumer_seq",
            "last_active": "last_active",
            "stream_seq": "stream_seq",
        }

        self._consumer_seq = consumer_seq
        self._last_active = last_active
        self._stream_seq = stream_seq

    @classmethod
    def from_dict(cls, dikt: dict) -> "ApisAPIRestRespSequenceInfo":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The apis.APIRestRespSequenceInfo of this ApisAPIRestRespSequenceInfo.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def consumer_seq(self):
        """Gets the consumer_seq of this ApisAPIRestRespSequenceInfo.

        Consumer is consumer level sequence number

        :return: The consumer_seq of this ApisAPIRestRespSequenceInfo.
        :rtype: int
        """
        return self._consumer_seq

    @consumer_seq.setter
    def consumer_seq(self, consumer_seq):
        """Sets the consumer_seq of this ApisAPIRestRespSequenceInfo.

        Consumer is consumer level sequence number

        :param consumer_seq: The consumer_seq of this ApisAPIRestRespSequenceInfo.
        :type consumer_seq: int
        """
        if consumer_seq is None:
            raise ValueError("Invalid value for `consumer_seq`, must not be `None`")

        self._consumer_seq = consumer_seq

    @property
    def last_active(self):
        """Gets the last_active of this ApisAPIRestRespSequenceInfo.

        Last timestamp when these values updated

        :return: The last_active of this ApisAPIRestRespSequenceInfo.
        :rtype: str
        """
        return self._last_active

    @last_active.setter
    def last_active(self, last_active):
        """Sets the last_active of this ApisAPIRestRespSequenceInfo.

        Last timestamp when these values updated

        :param last_active: The last_active of this ApisAPIRestRespSequenceInfo.
        :type last_active: str
        """

        self._last_active = last_active

    @property
    def stream_seq(self):
        """Gets the stream_seq of this ApisAPIRestRespSequenceInfo.

        Stream is stream level sequence number

        :return: The stream_seq of this ApisAPIRestRespSequenceInfo.
        :rtype: int
        """
        return self._stream_seq

    @stream_seq.setter
    def stream_seq(self, stream_seq):
        """Sets the stream_seq of this ApisAPIRestRespSequenceInfo.

        Stream is stream level sequence number

        :param stream_seq: The stream_seq of this ApisAPIRestRespSequenceInfo.
        :type stream_seq: int
        """
        if stream_seq is None:
            raise ValueError("Invalid value for `stream_seq`, must not be `None`")

        self._stream_seq = stream_seq
