# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq.models.apis_api_rest_resp_consumer_info import ApisAPIRestRespConsumerInfo
from httpmq.models.goutils_error_detail import GoutilsErrorDetail
from httpmq import util


class ApisAPIRestRespOneJetStreamConsumer(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(
        self,
        consumer: ApisAPIRestRespConsumerInfo = None,
        error: GoutilsErrorDetail = None,
        request_id: str = None,
        success: bool = None,
    ):
        """ApisAPIRestRespOneJetStreamConsumer - a model defined in OpenAPI

        :param consumer: The consumer of this ApisAPIRestRespOneJetStreamConsumer.
        :param error: The error of this ApisAPIRestRespOneJetStreamConsumer.
        :param request_id: The request_id of this ApisAPIRestRespOneJetStreamConsumer.
        :param success: The success of this ApisAPIRestRespOneJetStreamConsumer.
        """
        self.openapi_types = {
            "consumer": ApisAPIRestRespConsumerInfo,
            "error": GoutilsErrorDetail,
            "request_id": str,
            "success": bool,
        }

        self.attribute_map = {
            "consumer": "consumer",
            "error": "error",
            "request_id": "request_id",
            "success": "success",
        }

        self._consumer = consumer
        self._error = error
        self._request_id = request_id
        self._success = success

    @classmethod
    def from_dict(cls, dikt: dict) -> "ApisAPIRestRespOneJetStreamConsumer":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The apis.APIRestRespOneJetStreamConsumer of this ApisAPIRestRespOneJetStreamConsumer.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def consumer(self):
        """Gets the consumer of this ApisAPIRestRespOneJetStreamConsumer.


        :return: The consumer of this ApisAPIRestRespOneJetStreamConsumer.
        :rtype: ApisAPIRestRespConsumerInfo
        """
        return self._consumer

    @consumer.setter
    def consumer(self, consumer):
        """Sets the consumer of this ApisAPIRestRespOneJetStreamConsumer.


        :param consumer: The consumer of this ApisAPIRestRespOneJetStreamConsumer.
        :type consumer: ApisAPIRestRespConsumerInfo
        """

        self._consumer = consumer

    @property
    def error(self):
        """Gets the error of this ApisAPIRestRespOneJetStreamConsumer.


        :return: The error of this ApisAPIRestRespOneJetStreamConsumer.
        :rtype: GoutilsErrorDetail
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this ApisAPIRestRespOneJetStreamConsumer.


        :param error: The error of this ApisAPIRestRespOneJetStreamConsumer.
        :type error: GoutilsErrorDetail
        """

        self._error = error

    @property
    def request_id(self):
        """Gets the request_id of this ApisAPIRestRespOneJetStreamConsumer.

        RequestID gives the request ID to match against logs

        :return: The request_id of this ApisAPIRestRespOneJetStreamConsumer.
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        """Sets the request_id of this ApisAPIRestRespOneJetStreamConsumer.

        RequestID gives the request ID to match against logs

        :param request_id: The request_id of this ApisAPIRestRespOneJetStreamConsumer.
        :type request_id: str
        """
        if request_id is None:
            raise ValueError("Invalid value for `request_id`, must not be `None`")

        self._request_id = request_id

    @property
    def success(self):
        """Gets the success of this ApisAPIRestRespOneJetStreamConsumer.

        Success indicates whether the request was successful

        :return: The success of this ApisAPIRestRespOneJetStreamConsumer.
        :rtype: bool
        """
        return self._success

    @success.setter
    def success(self, success):
        """Sets the success of this ApisAPIRestRespOneJetStreamConsumer.

        Success indicates whether the request was successful

        :param success: The success of this ApisAPIRestRespOneJetStreamConsumer.
        :type success: bool
        """
        if success is None:
            raise ValueError("Invalid value for `success`, must not be `None`")

        self._success = success
