# coding: utf-8

from datetime import date, datetime

from typing import List, Dict, Type

from httpmq.models.base_model_ import Model
from httpmq.models.dataplane_msg_to_deliver_seq import DataplaneMsgToDeliverSeq
from httpmq.models.goutils_error_detail import GoutilsErrorDetail
from httpmq import util


class ApisAPIRestRespDataMessage(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(
        self,
        b64_msg: str = None,
        consumer: str = None,
        error: GoutilsErrorDetail = None,
        request_id: str = None,
        sequence: DataplaneMsgToDeliverSeq = None,
        stream: str = None,
        subject: str = None,
        success: bool = None,
    ):
        """ApisAPIRestRespDataMessage - a model defined in OpenAPI

        :param b64_msg: The b64_msg of this ApisAPIRestRespDataMessage.
        :param consumer: The consumer of this ApisAPIRestRespDataMessage.
        :param error: The error of this ApisAPIRestRespDataMessage.
        :param request_id: The request_id of this ApisAPIRestRespDataMessage.
        :param sequence: The sequence of this ApisAPIRestRespDataMessage.
        :param stream: The stream of this ApisAPIRestRespDataMessage.
        :param subject: The subject of this ApisAPIRestRespDataMessage.
        :param success: The success of this ApisAPIRestRespDataMessage.
        """
        self.openapi_types = {
            "b64_msg": str,
            "consumer": str,
            "error": GoutilsErrorDetail,
            "request_id": str,
            "sequence": DataplaneMsgToDeliverSeq,
            "stream": str,
            "subject": str,
            "success": bool,
        }

        self.attribute_map = {
            "b64_msg": "b64_msg",
            "consumer": "consumer",
            "error": "error",
            "request_id": "request_id",
            "sequence": "sequence",
            "stream": "stream",
            "subject": "subject",
            "success": "success",
        }

        self._b64_msg = b64_msg
        self._consumer = consumer
        self._error = error
        self._request_id = request_id
        self._sequence = sequence
        self._stream = stream
        self._subject = subject
        self._success = success

    @classmethod
    def from_dict(cls, dikt: dict) -> "ApisAPIRestRespDataMessage":
        """Returns the dict as a model

        :param dikt: A dict.
        :return: The apis.APIRestRespDataMessage of this ApisAPIRestRespDataMessage.
        """
        return util.deserialize_model(dikt, cls)

    @property
    def b64_msg(self):
        """Gets the b64_msg of this ApisAPIRestRespDataMessage.

        Message is the message body

        :return: The b64_msg of this ApisAPIRestRespDataMessage.
        :rtype: str
        """
        return self._b64_msg

    @b64_msg.setter
    def b64_msg(self, b64_msg):
        """Sets the b64_msg of this ApisAPIRestRespDataMessage.

        Message is the message body

        :param b64_msg: The b64_msg of this ApisAPIRestRespDataMessage.
        :type b64_msg: str
        """
        if b64_msg is None:
            raise ValueError("Invalid value for `b64_msg`, must not be `None`")

        self._b64_msg = b64_msg

    @property
    def consumer(self):
        """Gets the consumer of this ApisAPIRestRespDataMessage.

        Consumer is the name of the consumer

        :return: The consumer of this ApisAPIRestRespDataMessage.
        :rtype: str
        """
        return self._consumer

    @consumer.setter
    def consumer(self, consumer):
        """Sets the consumer of this ApisAPIRestRespDataMessage.

        Consumer is the name of the consumer

        :param consumer: The consumer of this ApisAPIRestRespDataMessage.
        :type consumer: str
        """
        if consumer is None:
            raise ValueError("Invalid value for `consumer`, must not be `None`")

        self._consumer = consumer

    @property
    def error(self):
        """Gets the error of this ApisAPIRestRespDataMessage.


        :return: The error of this ApisAPIRestRespDataMessage.
        :rtype: GoutilsErrorDetail
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this ApisAPIRestRespDataMessage.


        :param error: The error of this ApisAPIRestRespDataMessage.
        :type error: GoutilsErrorDetail
        """

        self._error = error

    @property
    def request_id(self):
        """Gets the request_id of this ApisAPIRestRespDataMessage.

        RequestID gives the request ID to match against logs

        :return: The request_id of this ApisAPIRestRespDataMessage.
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        """Sets the request_id of this ApisAPIRestRespDataMessage.

        RequestID gives the request ID to match against logs

        :param request_id: The request_id of this ApisAPIRestRespDataMessage.
        :type request_id: str
        """
        if request_id is None:
            raise ValueError("Invalid value for `request_id`, must not be `None`")

        self._request_id = request_id

    @property
    def sequence(self):
        """Gets the sequence of this ApisAPIRestRespDataMessage.


        :return: The sequence of this ApisAPIRestRespDataMessage.
        :rtype: DataplaneMsgToDeliverSeq
        """
        return self._sequence

    @sequence.setter
    def sequence(self, sequence):
        """Sets the sequence of this ApisAPIRestRespDataMessage.


        :param sequence: The sequence of this ApisAPIRestRespDataMessage.
        :type sequence: DataplaneMsgToDeliverSeq
        """
        if sequence is None:
            raise ValueError("Invalid value for `sequence`, must not be `None`")

        self._sequence = sequence

    @property
    def stream(self):
        """Gets the stream of this ApisAPIRestRespDataMessage.

        Stream is the name of the stream

        :return: The stream of this ApisAPIRestRespDataMessage.
        :rtype: str
        """
        return self._stream

    @stream.setter
    def stream(self, stream):
        """Sets the stream of this ApisAPIRestRespDataMessage.

        Stream is the name of the stream

        :param stream: The stream of this ApisAPIRestRespDataMessage.
        :type stream: str
        """
        if stream is None:
            raise ValueError("Invalid value for `stream`, must not be `None`")

        self._stream = stream

    @property
    def subject(self):
        """Gets the subject of this ApisAPIRestRespDataMessage.

        Subject is the name of the subject / subject filter

        :return: The subject of this ApisAPIRestRespDataMessage.
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """Sets the subject of this ApisAPIRestRespDataMessage.

        Subject is the name of the subject / subject filter

        :param subject: The subject of this ApisAPIRestRespDataMessage.
        :type subject: str
        """
        if subject is None:
            raise ValueError("Invalid value for `subject`, must not be `None`")

        self._subject = subject

    @property
    def success(self):
        """Gets the success of this ApisAPIRestRespDataMessage.

        Success indicates whether the request was successful

        :return: The success of this ApisAPIRestRespDataMessage.
        :rtype: bool
        """
        return self._success

    @success.setter
    def success(self, success):
        """Sets the success of this ApisAPIRestRespDataMessage.

        Success indicates whether the request was successful

        :param success: The success of this ApisAPIRestRespDataMessage.
        :type success: bool
        """
        if success is None:
            raise ValueError("Invalid value for `success`, must not be `None`")

        self._success = success
